package cn.schoolwow.quickapi.flow.common;

import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;

public class SortFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Class clazz = (Class) flowContext.checkData("clazz");
        JSONObject amsListCondition = (JSONObject) flowContext.checkData("amsListCondition");
        String sortField = amsListCondition.getString("sortField");
        String sortOrder = amsListCondition.getString("sortOrder");
        List list = (List) flowContext.getData("list");

        if (StringUtils.isBlank(sortField)||StringUtils.isBlank(sortOrder)) {
            return;
        }
        if(null==list||list.isEmpty()){
            return;
        }
        Field field = clazz.getDeclaredField(sortField);
        field.setAccessible(true);

        list.sort(new Comparator<APIController>() {
            @Override
            public int compare(APIController o1, APIController o2) {
                // 获取指定字段的值
                Comparable fieldValue1 = getFieldValue(o1, field);
                Comparable fieldValue2 = getFieldValue(o2, field);

                // 根据排序方式进行比较
                if (sortOrder.equals("asc")) {
                    return fieldValue1.compareTo(fieldValue2);
                } else {
                    return fieldValue2.compareTo(fieldValue1);
                }
            }
        });
    }

    @Override
    public String name() {
        return "列表排序";
    }

    private Comparable getFieldValue(Object o, Field field) {
        try {
            Object value = field.get(o);
            return (Comparable) value;
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }
}
