package cn.schoolwow.quickapi.flow.common;

import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FilterFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Class clazz = (Class) flowContext.checkData("clazz");
        JSONObject amsListCondition = (JSONObject) flowContext.checkData("amsListCondition");
        List<Object> list = (List) flowContext.getData("list", new ArrayList<>());

        Field[] fields = clazz.getDeclaredFields();
        Field.setAccessible(fields, true);

        List<Object> filterList = new ArrayList(list);
        flowContext.putTemporaryData("filterList", filterList);
        for(Field field:fields){
            if(Modifier.isTransient(field.getModifiers())){
                continue;
            }
            if(null!=field.getAnnotation(Ignore.class)){
                continue;
            }
            if(!amsListCondition.containsKey(field.getName())){
                continue;
            }
            Object value = amsListCondition.get(field.getName());
            in(field, value, flowContext);
            like(field, value, flowContext);
            equal(field, value, flowContext);
        }
        flowContext.putTemporaryData("list", filterList);
    }

    @Override
    public String name() {
        return "列表过滤";
    }

    private void in(Field field, Object value, FlowContext flowContext) throws IllegalAccessException {
        if(!value.toString().startsWith("in:")){
            return;
        }
        String[] values = value.toString().substring(3).split(",", -1);
        List valueList = Arrays.asList(values);
        List<Object> filterList = (List) flowContext.getData("filterList", new ArrayList<>());
        Iterator iterator = filterList.iterator();
        while(iterator.hasNext()){
            Object obj = iterator.next();
            Object instanceValue = field.get(obj);
            if(!valueList.contains(instanceValue)){
                iterator.remove();
            }
        }
    }

    private void like(Field field, Object value, FlowContext flowContext) throws IllegalAccessException {
        if(!value.toString().startsWith("like:")){
            return;
        }
        String likeValue = value.toString().substring(5).replace("%", ".*");
        List<Object> filterList = (List) flowContext.getData("filterList", new ArrayList<>());
        Iterator iterator = filterList.iterator();
        while(iterator.hasNext()){
            Object obj = iterator.next();
            Object instanceValue = field.get(obj);
            if(instanceValue instanceof String){
                if(!instanceValue.toString().matches(likeValue)){
                    iterator.remove();
                }
            }
        }
    }

    private void equal(Field field, Object value, FlowContext flowContext) throws IllegalAccessException {
        List<Object> filterList = (List) flowContext.getData("filterList", new ArrayList<>());
        Iterator iterator = filterList.iterator();
        while(iterator.hasNext()){
            Object obj = iterator.next();
            Object instanceValue = field.get(obj);
            if(instanceValue instanceof String){
                if(!instanceValue.toString().contains(value.toString())){
                    iterator.remove();
                }
            }else if(!value.equals(instanceValue)){
                iterator.remove();
            }
        }
    }
}
