package cn.schoolwow.quickapi.domain;

import cn.schoolwow.quickdao.annotation.Comment;

import java.lang.reflect.Parameter;

@Comment("接口请求参数")
public class APIParameter {
    @Comment("关联控制器类名")
    public String controllerClassName;

    @Comment("关联方法名")
    public String methodName;

    @Comment("接口名称")
    public String apiName;

    @Comment("参数名称")
    public String name;

    @Comment("注解参数名称")
    public String annotationParameterName;

    @Comment("描述")
    public String description;

    @Comment("参数类型类名")
    public String typeClassName;

    @Comment("参数请求类型(text:text,file:file)")
    public String requestType = "text";

    @Comment("参数位置(query:路径,body:请求体)")
    public String position = "query";

    @Comment("是否必须")
    public boolean required = true;

    @Comment("默认值")
    public String defaultValue = "";

    @Comment("参数")
    public transient Parameter parameter;

    @Comment("关联接口对象")
    public transient API api;

}
