package cn.schoolwow.quickapi.domain;

import cn.schoolwow.quickdao.annotation.Comment;

import java.lang.reflect.Field;

@Comment("实体类字段")
public class APIField {
    @Comment("关联实体类名")
    public String entityClassName;

    @Comment("字段名")
    public String name;

    @Comment("描述")
    public String description;

    @Comment("字段类型")
    public String className;

    @Comment("字段泛型类型")
    public String genericTypeClassName;

    @Comment("是否必须")
    public boolean required;

    @Comment("字段")
    public transient Field field;

    /**
     * 添加描述
     * */
    public void setDescription(String description){
        if(null!=description&&!description.isEmpty()){
            this.description = description;
        }
    }
}