package cn.schoolwow.quickapi.domain;

import cn.schoolwow.quickdao.annotation.Comment;
import com.alibaba.fastjson.JSONObject;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@Comment("接口")
public class API {
    @Comment("关联控制器类名")
    public String controllerClassName;

    @Comment("方法名称")
    public String methodName;

    @Comment("描述")
    public String description;

    @Comment("是否被废弃")
    public boolean deprecated;

    @Comment("请求方法(GET:GET,POST:POST,PUT:PUT,DELETE:DELETE)")
    public String requestMethod = "POST";

    @Comment("请求地址")
    public String url;

    @Comment("请求头部")
    public JSONObject headerMap = new JSONObject();

    @Comment("作者")
    public String author;

    @Comment("日期")
    public String since;

    @Comment("请求编码")
    public String contentType;

    @Comment("参数个数")
    public Integer parameterCount;

    @Comment("请求体")
    public JSONObject body;

    @Comment("返回值类名")
    public String returnClassName;

    @Comment("关联请求参数实体类")
    public List<String> parameterEntityNameList = new ArrayList<>();

    @Comment("关联返回值实体类")
    public List<String> returnEntityNameList = new ArrayList<>();

    @Comment("抛出异常")
    public transient APIException[] apiExceptions;

    @Comment("方法")
    public transient Method method;

    @Comment("关联控制器对象")
    public transient APIController apiController;

    /**
     * 设置描述
     * */
    public void setDescription(String description){
        if(null==this.description&&null!=description&&!description.isEmpty()){
            this.description = description;
        }
    }
}