package cn.schoolwow.quickapi.config;

import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickapi.flow.initial.*;
import cn.schoolwow.quickflow.QuickFlow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages = "cn.schoolwow.quickapi.ams")
public class QuickAPIConfiguration {
    @Bean
    public QuickFlow apiFlow(@Autowired(required = false) QuickAPIOption quickAPIOption){
        QuickFlow apiFlow = QuickFlow.newInstance()
                .putContextData("apiDocument", new APIDocument());
        if(null!=quickAPIOption){
            apiFlow.putContextData("quickAPIOption", quickAPIOption);
            if(null!=quickAPIOption.apiFlowConsumer){
                quickAPIOption.apiFlowConsumer.accept(apiFlow);
            }
        }
        apiFlow.startFlow("初始化接口文档")
                .next(new GetAPIControllerFlow())
                .next(new GetAPIListFlow())
                .next(new GetAPIParameterFlow())
                .next(new GetAPIEntityFlow())
                .next(new GetJavaDocFlow())
                .next(new HandleConsumerFlow())
                .next(new SetAPIEntityAndFieldListFlow())
                .execute();
        return apiFlow;
    }
}