package cn.schoolwow.quickapi.ams.listener.routerpush;

import cn.schoolwow.ams.domain.listener.routerpush.AMSRouterPush;
import cn.schoolwow.ams.listener.AMSRouterPushAware;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service
public class APIController2APIRouterPush implements AMSRouterPushAware {
    @Override
    public List<AMSRouterPush> getAMSRouterPushList() {
        return Arrays.asList(new AMSRouterPush()
                .projectName("quickapi")
                .daoName("clazz")
                .tableName("APIController")
                .name("viewAPIList")
                .label("接口列表")
                .path("/api/quickapi|clazz|API")
                .queryFieldNameListMap("controllerClassName", "className")
        );
    }
}
