package cn.schoolwow.quickapi.ams.listener.operation;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class APIControllerListCopyOperation implements AMSOperationAware {
    @Resource
    private QuickFlow apiFlow;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName("quickapi")
                .daoName("clazz")
                .tableName("APIController")
                .methodName("copyAPIControllerList")
                .position(AMSOperationPosition.RightTop)
                .name("复制控制器列表")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        APIDocument apiDocument = (APIDocument) apiFlow.getContextData("apiDocument");
                        JSONObject o = new JSONObject();
                        o.put("body", apiDocument.apiControllerList);
                        return o;
                    }
                })
        );
    }
}
