package cn.schoolwow.quickapi.ams.listener.list;

import cn.schoolwow.ams.domain.listener.list.AMSListBlock;
import cn.schoolwow.ams.listener.AMSListBlockAware;
import cn.schoolwow.quickapi.domain.*;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class QuickAPIListBlock implements AMSListBlockAware {
    @Override
    public List<AMSListBlock> getListBlockList() {
        List<AMSListBlock> listBlockList = new ArrayList<>();
        listBlockList.add(new AMSListBlock().projectName("quickapi").classBlock(APIController.class)
                .existFieldName("className", "description", "prefix", "deprecated")
                .simulate()
                .sort("createdTime", "desc")
        );
        listBlockList.add(new AMSListBlock().projectName("quickapi").classBlock(API.class)
                .existFieldName("description", "requestMethod", "url", "headerMap", "author", "since", "contentType", "body", "returnClassName")
                .simulate()
        );
        listBlockList.add(new AMSListBlock().projectName("quickapi").classBlock(APIParameter.class)
                .existFieldName("apiName", "description", "typeClassName", "requestType", "position", "required", "defaultValue")
                .simulate()
        );
        listBlockList.add(new AMSListBlock().projectName("quickapi").classBlock("ParameterEntity", APIEntity.class, APIEntity.class)
                .simulate()
        );
        listBlockList.add(new AMSListBlock().projectName("quickapi").classBlock("ReturnEntity", APIEntity.class, APIEntity.class)
                .simulate()
        );
        listBlockList.add(new AMSListBlock().projectName("quickapi").classBlock(APIField.class)
                .simulate());
        listBlockList.add(new AMSListBlock().projectName("quickapi").classBlock("GlobalHeader", null, GlobalHeader.class)
                .simulate()
        );
        return listBlockList;
    }
}
