package cn.schoolwow.quickapi.ams.listener.dialog;

import cn.schoolwow.ams.domain.listener.dialog.AMSDialog;
import cn.schoolwow.ams.domain.listener.dialog.AddBlockItemDialogOption;
import cn.schoolwow.ams.domain.listener.dialog.EditBlockItemDialogOption;
import cn.schoolwow.ams.listener.AMSDialogAware;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service
public class GlobalHeaderDialog implements AMSDialogAware {
    @Override
    public List<AMSDialog> getAMSDialogList() {
        return Arrays.asList(new AMSDialog()
                .projectName("quickapi")
                .daoName("clazz")
                .tableName("GlobalHeader")
                .name("全局头部")
                .addBlockItemDialogOption(new AddBlockItemDialogOption()
                        .addFieldNameList("headerName", "headerValue")
                )
                .editBlockItemDialogOption(new EditBlockItemDialogOption())
                .setDeleteField("headerName")
        );
    }
}
