package cn.schoolwow.quickapi.ams.listener.clazz;

import cn.schoolwow.ams.domain.listener.clazz.*;
import cn.schoolwow.ams.listener.AMSClazzListenerAware;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickapi.domain.GlobalHeader;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class GlobalHeaderListener implements AMSClazzListenerAware {
    @Autowired(required = false)
    private QuickAPIOption quickAPIOption;

    @Override
    public List<AMSClazzListener> getAMSClazzListenerList() {
        return Arrays.asList(new AMSClazzListener()
                .projectName("quickapi")
                .className("GlobalHeader")
                .list(new ListClazzListener() {
                    @Override
                    public JSONObject list(Map<String, Object> amsListConditionMap) {
                        List<GlobalHeader> globalHeaderList = new ArrayList<>();
                        if(null==quickAPIOption){
                            return AMSUtil.getAMSList(globalHeaderList);
                        }
                        for(Map.Entry<String,Object> entry:quickAPIOption.headerMap.entrySet()){
                            GlobalHeader globalHeader = new GlobalHeader();
                            globalHeader.headerName = entry.getKey();
                            globalHeader.headerValue = null==entry.getValue()?"":entry.getValue().toString();
                            globalHeaderList.add(globalHeader);
                        }
                        return AMSUtil.getAMSList(globalHeaderList);
                    }
                })
                .create(new CreateClazzListener() {
                    @Override
                    public void create(JSONObject createEntity) {
                        if(null!=quickAPIOption){
                            String headerName = createEntity.getString("headerName");
                            String headerValue = createEntity.getString("headerValue");
                            quickAPIOption.headerMap.put(headerName, headerValue);
                        }
                    }
                })
                .edit(new EditClazzListener() {
                    @Override
                    public void edit(JSONObject updateEntity) {
                        if(null!=quickAPIOption){
                            String headerName = updateEntity.getString("headerName");
                            String headerValue = updateEntity.getString("headerValue");
                            quickAPIOption.headerMap.put(headerName, headerValue);
                        }
                    }
                })
                .delete(new DeleteClazzListener() {
                    @Override
                    public void delete(Map<String, Object> amsListConditionMap) {
                        if(null!=quickAPIOption){
                            String headerName = (String) amsListConditionMap.get("headerName");
                            if(headerName.startsWith("in:")){
                                String[] headerNames = headerName.substring(3).split(",", -1);
                                for(String headerName1:headerNames){
                                    quickAPIOption.headerMap.remove(headerName1);
                                }
                            }else{
                                quickAPIOption.headerMap.remove(headerName);
                            }
                        }
                    }
                })
        );
    }
}
