package cn.schoolwow.quickapi.ams.listener.clazz;

import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.listener.AMSClazzListenerAware;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIField;
import cn.schoolwow.quickapi.flow.controller.GetListFlow;
import cn.schoolwow.quickapi.flow.handler.ListBeforeAfterHandler;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class APIFieldListener implements AMSClazzListenerAware {
    @Resource
    private QuickFlow apiFlow;

    @Override
    public List<AMSClazzListener> getAMSClazzListenerList() {
        return Arrays.asList(new AMSClazzListener()
                .projectName("quickapi")
                .className("APIField")
                .list(new ListClazzListener() {
                    @Override
                    public JSONObject list(Map<String, Object> amsListConditionMap) {
                        JSONObject amsListCondition = new JSONObject(amsListConditionMap);

                        FlowContext flowContext = apiFlow.startFlow(new GetListFlow())
                                .beforeAfterFlowHandler(new ListBeforeAfterHandler())
                                .putCurrentCompositeFlowData("clazz", APIField.class)
                                .putCurrentCompositeFlowData("amsListCondition", amsListCondition)
                                .execute();
                        List<APIEntity> list = (List<APIEntity>) flowContext.getData("list");
                        return AMSUtil.getAMSList(list);
                    }
                })
        );
    }
}
