/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIException;
import cn.schoolwow.quickapi.domain.APIField;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.handler.ConsumerHandler;
import cn.schoolwow.quickapi.handler.Handler;
import cn.schoolwow.quickapi.util.JavaDocUtil;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDocHandler
extends AbstractHandler {
    private Logger logger = LoggerFactory.getLogger(JavaDocHandler.class);

    public JavaDocHandler(QuickAPIOption option) {
        super(option);
    }

    @Override
    public Handler handle(APIDocument apiDocument) throws Exception {
        if (null != this.option.sourcePath && Files.exists(Paths.get(this.option.sourcePath, new String[0]), new LinkOption[0])) {
            ClassDoc[] classDocs = JavaDocUtil.getJavaDoc(apiDocument, this.option);
            this.handleAPIController(classDocs, apiDocument.apiControllerList);
            this.handleAPIEntity(classDocs, apiDocument);
        } else {
            this.logger.info("[\u65e0\u6cd5\u8bfb\u53d6\u6e90\u6587\u4ef6\u6ce8\u91ca]\u6e90\u6587\u4ef6\u8def\u5f84\u672a\u8bbe\u7f6e\u6216\u8005\u8def\u5f84\u4e0d\u5b58\u5728!\u6e90\u6587\u4ef6\u8def\u5f84:{}", (Object)this.option.sourcePath);
        }
        for (APIController apiController : apiDocument.apiControllerList) {
            apiController.setDisplayName(apiController.clazz.getSimpleName());
            for (API api : apiController.apiList) {
                api.setDisplayName(api.methodName);
            }
        }
        return new ConsumerHandler(this.option);
    }

    private void handleAPIController(ClassDoc[] classDocs, List<APIController> apiControllerList) {
        for (APIController apiController : apiControllerList) {
            for (ClassDoc classDoc : classDocs) {
                if (!apiController.className.equals(classDoc.qualifiedName())) continue;
                apiController.setDisplayName(classDoc.commentText());
                apiController.setDescription(classDoc.commentText());
                if (null != this.option.classDocConsumer) {
                    this.option.classDocConsumer.accept(classDoc, apiController);
                }
                MethodDoc[] methodDocs = classDoc.methods();
                block2: for (API api : apiController.apiList) {
                    for (MethodDoc methodDoc : methodDocs) {
                        Tag[] sinceTags;
                        if (!api.method.getName().equals(methodDoc.name()) || api.method.getParameterCount() != methodDoc.parameters().length) continue;
                        api.setDisplayName(methodDoc.commentText());
                        api.setDescription(methodDoc.commentText());
                        Tag[] authorTags = methodDoc.tags("author");
                        if (null != authorTags && authorTags.length > 0) {
                            api.author = authorTags[0].text();
                        }
                        if (null != (sinceTags = methodDoc.tags("since")) && sinceTags.length > 0) {
                            api.since = sinceTags[0].text();
                        }
                        ParamTag[] paramTags = methodDoc.paramTags();
                        block4: for (APIParameter apiParameter : api.apiParameterList) {
                            ParamTag[] paramTagArray = paramTags;
                            int n = paramTagArray.length;
                            for (int i = 0; i < n; ++i) {
                                ParamTag paramTag = paramTagArray[i];
                                if (null == apiParameter.parameter || !apiParameter.parameterName.equals(paramTag.parameterName())) continue;
                                apiParameter.setName(paramTag.parameterName());
                                apiParameter.setDescription(paramTag.parameterComment());
                                continue block4;
                            }
                        }
                        ThrowsTag[] throwsTags = methodDoc.throwsTags();
                        if (null != throwsTags && throwsTags.length > 0) {
                            block6: for (APIException apiException : api.apiExceptions) {
                                for (int i = 0; i < throwsTags.length; ++i) {
                                    if (!apiException.className.equalsIgnoreCase(throwsTags[i].exceptionName())) continue;
                                    apiException.description = throwsTags[i].exceptionComment();
                                    continue block6;
                                }
                            }
                        }
                        if (null == this.option.methodDocConsumer) continue block2;
                        this.option.methodDocConsumer.accept(methodDoc, api);
                        continue block2;
                    }
                }
            }
        }
    }

    private void handleAPIEntity(ClassDoc[] classDocs, APIDocument apiDocument) {
        block0: for (APIEntity apiEntity : apiDocument.apiEntityMap.values()) {
            for (ClassDoc classDoc : classDocs) {
                Tag[] sinceTags;
                if (!apiEntity.className.equals(classDoc.qualifiedName())) continue;
                apiEntity.setDescription(classDoc.commentText());
                Tag[] authorTags = classDoc.tags("author");
                if (null != authorTags && authorTags.length > 0) {
                    apiEntity.author = authorTags[0].text();
                }
                if (null != (sinceTags = classDoc.tags("since")) && sinceTags.length > 0) {
                    apiEntity.since = sinceTags[0].text();
                }
                block2: for (APIField apiField : apiEntity.apiFields) {
                    for (FieldDoc fieldDoc : JavaDocHandler.getAllFieldDoc(classDoc)) {
                        if (!apiField.name.equals(fieldDoc.name())) continue;
                        apiField.setDescription(fieldDoc.commentText());
                        continue block2;
                    }
                }
                continue block0;
            }
        }
    }

    public static FieldDoc[] getAllFieldDoc(ClassDoc classDoc) {
        ArrayList<FieldDoc> fieldDocList = new ArrayList<FieldDoc>();
        ClassDoc tempClassDoc = classDoc;
        while (null != tempClassDoc) {
            FieldDoc[] fieldDocs;
            for (FieldDoc fieldDoc : fieldDocs = tempClassDoc.fields()) {
                if (Modifier.isFinal(fieldDoc.modifierSpecifier()) || Modifier.isStatic(fieldDoc.modifierSpecifier())) continue;
                fieldDocList.add(fieldDoc);
            }
            if (null == (tempClassDoc = tempClassDoc.superclass()) || !"java.lang.Object".equals(tempClassDoc.qualifiedName())) continue;
            break;
        }
        return fieldDocList.toArray(new FieldDoc[0]);
    }
}

