/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIField;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.handler.Handler;
import cn.schoolwow.quickapi.handler.JavaDocHandler;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIEntityHandler
extends AbstractHandler {
    private Logger logger = LoggerFactory.getLogger(APIEntityHandler.class);

    public APIEntityHandler(QuickAPIOption option) {
        super(option);
    }

    @Override
    public Handler handle(APIDocument apiDocument) throws Exception {
        if (null != this.option.apiEntityPredicate) {
            for (APIController apiController : apiDocument.apiControllerList) {
                for (API api : apiController.apiList) {
                    for (APIParameter apiParameter : api.apiParameterList) {
                        api.parameterEntityNameList.addAll(this.getRecycleAPIEntity(apiParameter.parameter.getType(), apiDocument));
                        api.parameterEntityNameList.addAll(this.getRecycleAPIEntity(this.getGenericTypeClass(apiParameter.parameter.getParameterizedType()), apiDocument));
                    }
                    api.returnEntityNameList.addAll(this.getRecycleAPIEntity(api.method.getReturnType(), apiDocument));
                    api.returnEntityNameList.addAll(this.getRecycleAPIEntity(this.getGenericTypeClass(api.method.getGenericReturnType()), apiDocument));
                }
            }
        } else {
            this.logger.warn("[\u672a\u626b\u63cf\u5b9e\u4f53\u7c7b\u4fe1\u606f]\u82e5\u8981\u626b\u63cf\u5b9e\u4f53\u7c7b,\u8bf7\u8bbe\u7f6eapiEntityPredicate\u5c5e\u6027!");
        }
        return new JavaDocHandler(this.option);
    }

    private List<String> getRecycleAPIEntity(Class rootClazz, APIDocument apiDocument) throws ClassNotFoundException {
        ArrayList<String> classNameList = new ArrayList<String>();
        if (null == rootClazz) {
            return classNameList;
        }
        Stack apiEntityClassStack = new Stack();
        apiEntityClassStack.push(rootClazz);
        while (!apiEntityClassStack.isEmpty()) {
            Class clazz = (Class)apiEntityClassStack.pop();
            if (!this.option.apiEntityPredicate.test(clazz)) continue;
            APIEntity apiEntity = this.getAPIEntity(clazz);
            classNameList.add(apiEntity.className);
            if (!apiDocument.apiEntityMap.containsKey(apiEntity.className)) {
                apiDocument.apiEntityMap.put(apiEntity.className, apiEntity);
            }
            for (APIField apiField : apiEntity.apiFields) {
                apiEntityClassStack.push(apiField.field.getType());
                if (!apiField.className.contains("<")) continue;
                String genericTypeName = apiField.className.substring(apiField.className.indexOf("<") + 1, apiField.className.lastIndexOf(">"));
                apiEntityClassStack.push(ClassLoader.getSystemClassLoader().loadClass(genericTypeName));
            }
        }
        return classNameList;
    }

    private APIEntity getAPIEntity(Class clazz) {
        if (null != clazz.getComponentType()) {
            clazz = clazz.getComponentType();
        }
        APIEntity apiEntity = new APIEntity();
        apiEntity.clazz = clazz;
        apiEntity.className = clazz.getName();
        apiEntity.simpleName = clazz.getSimpleName();
        Field[] fields = this.getAllField(clazz);
        APIField[] apiFields = new APIField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            APIField apiField = new APIField();
            apiField.field = fields[i];
            apiField.name = fields[i].getName();
            apiField.className = fields[i].getType().getName();
            Type fieldType = fields[i].getGenericType();
            if (fieldType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)fieldType;
                Type genericType = pType.getActualTypeArguments()[0];
                apiField.className = apiField.className + "<" + genericType.getTypeName() + ">";
            }
            apiFields[i] = apiField;
        }
        apiEntity.apiFields = apiFields;
        try {
            apiEntity.instance = JSON.toJSONString(clazz.newInstance(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
        catch (Exception e) {
            this.logger.warn("[\u5b9e\u4f8b\u5316\u5931\u8d25]\u539f\u56e0:{},\u7c7b\u540d:{}", (Object)e.getMessage(), (Object)clazz.getName());
        }
        return apiEntity;
    }

    private Field[] getAllField(Class clazz) {
        AccessibleObject[] fields;
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        for (Class tempClass = clazz; null != tempClass; tempClass = tempClass.getSuperclass()) {
            fields = tempClass.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isFinal(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).setAccessible(true);
                fieldList.add(field);
            }
        }
        fields = fieldList.toArray(new Field[0]);
        Field.setAccessible(fields, true);
        return fields;
    }

    private Class getGenericTypeClass(Type type) throws ClassNotFoundException {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type genericType = pType.getActualTypeArguments()[0];
            return ClassLoader.getSystemClassLoader().loadClass(genericType.getTypeName());
        }
        return null;
    }
}

