/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickapi.handler.APIHandler;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.handler.Handler;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public class APIControllerHandler
extends AbstractHandler {
    public APIControllerHandler(QuickAPIOption option) {
        super(option);
    }

    @Override
    public Handler handle(APIDocument apiDocument) throws Exception {
        ArrayList<APIController> apiControllerList = new ArrayList<APIController>();
        List<String> classNameList = this.getAllClassNameList();
        for (String className : classNameList) {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(className);
            if (null == clazz.getAnnotation(Controller.class) && null == clazz.getAnnotation(RestController.class)) continue;
            APIController apiController = new APIController();
            apiController.className = className;
            apiController.clazz = clazz;
            if (null != apiController.clazz.getAnnotation(Deprecated.class)) {
                apiController.deprecated = true;
            }
            apiControllerList.add(apiController);
        }
        apiDocument.apiControllerList = apiControllerList;
        return new APIHandler(this.option);
    }

    private List<String> getAllClassNameList() throws Exception {
        final ArrayList<String> classNameList = new ArrayList<String>(1024);
        Enumeration<URL> urlEnumeration = ClassLoader.getSystemClassLoader().getResources("");
        block8: while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            if (url == null) continue;
            switch (url.getProtocol()) {
                case "file": {
                    final File directoryFile = new File(url.getFile());
                    if (!directoryFile.isDirectory()) {
                        throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                    }
                    Files.walkFileTree(directoryFile.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            File file = path.toFile();
                            if (file.getName().endsWith(".class")) {
                                String className = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 6).substring(directoryFile.getAbsolutePath().length() + 1).replace('/', '.').replace('\\', '.');
                                classNameList.add(className);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                case "jar": {
                    JarFile jarFile;
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) continue block8;
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry jarEntry = jarEntries.nextElement();
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntryName.endsWith(".class")) continue;
                        String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                        classNameList.add(className);
                    }
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684url\u534f\u8bae!\u5f53\u524durl\u534f\u8bae:" + url.getProtocol());
                }
            }
        }
        return classNameList;
    }
}

