/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.util;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.util.JavaDocReader;
import cn.schoolwow.quickapi.util.QuickAPIConfig;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public class ReflectionUtil {
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);
    private static LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();

    public static List<APIController> getAPIList(List<Class> classList) {
        ArrayList<APIController> apiControllerList = new ArrayList<APIController>();
        for (Class _class : classList) {
            String baseUrl = "";
            RequestMapping classRequestMapping = _class.getDeclaredAnnotation(RequestMapping.class);
            if (classRequestMapping != null) {
                baseUrl = classRequestMapping.value()[0];
            }
            APIController apiController = new APIController();
            apiController.className = _class.getSimpleName();
            apiController.tag = _class.getSimpleName();
            ArrayList<API> apiList = new ArrayList<API>();
            for (Method method : _class.getDeclaredMethods()) {
                RequestMapping methodRequestMapping = method.getDeclaredAnnotation(RequestMapping.class);
                if (methodRequestMapping == null) continue;
                API api = new API();
                api.brief = api.methodName = method.getName();
                RequestMethod[] requestMethods = methodRequestMapping.method();
                if (requestMethods.length > 0) {
                    api.methods = new String[requestMethods.length];
                    for (int i = 0; i < requestMethods.length; ++i) {
                        api.methods[i] = requestMethods[i].name().toUpperCase();
                    }
                } else {
                    api.methods = new String[]{"all"};
                }
                api.url = baseUrl + methodRequestMapping.value()[0];
                api.apiParameters = ReflectionUtil.handleParameter(api, method);
                api.returnValue = method.getGenericReturnType().getTypeName();
                apiList.add(api);
            }
            if (apiList.size() == 0) continue;
            apiController.apiList = apiList;
            apiControllerList.add(apiController);
        }
        ClassDoc[] classDocs = JavaDocReader.extractJavaDoc();
        block3: for (APIController apiController : apiControllerList) {
            for (ClassDoc classDoc : classDocs) {
                if (!apiController.className.equals(classDoc.name())) continue;
                Tag[] tags = classDoc.tags("tag");
                if (tags != null && tags.length > 0) {
                    apiController.tag = tags[0].text();
                }
                MethodDoc[] methodDocs = classDoc.methods();
                block5: for (API api : apiController.apiList) {
                    for (MethodDoc methodDoc : methodDocs) {
                        if (!api.methodName.equals(methodDoc.name())) continue;
                        Tag[] briefs = methodDoc.tags("brief");
                        if (briefs != null && briefs.length > 0) {
                            api.brief = briefs[0].text();
                        }
                        api.description = methodDoc.commentText();
                        ParamTag[] paramTags = methodDoc.paramTags();
                        block7: for (APIParameter apiParameter : api.apiParameters) {
                            for (ParamTag paramTag : paramTags) {
                                if (!apiParameter.name.equals(paramTag.parameterName())) continue;
                                apiParameter.name = paramTag.parameterName();
                                apiParameter.description = paramTag.parameterComment();
                                continue block7;
                            }
                        }
                        continue block5;
                    }
                }
                continue block3;
            }
        }
        return apiControllerList;
    }

    private static APIParameter[] handleParameter(API api, Method method) {
        Parameter[] parameters = method.getParameters();
        String[] parameterNames = u.getParameterNames(method);
        ArrayList<APIParameter> apiParameterList = new ArrayList<APIParameter>();
        for (int i = 0; i < parameters.length; ++i) {
            PathVariable pathVariable;
            RequestBody requestBody;
            RequestPart requestPart;
            if (parameters[i].getType().getName().startsWith("javax.servlet")) continue;
            APIParameter apiParameter = new APIParameter();
            RequestParam requestParam = parameters[i].getAnnotation(RequestParam.class);
            if (requestParam != null) {
                apiParameter.name = requestParam.value();
                if (apiParameter.name.isEmpty()) {
                    apiParameter.name = requestParam.name();
                }
                apiParameter.required = requestParam.required();
                if (!requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                    apiParameter.defaultValue = requestParam.defaultValue();
                }
            }
            if ((requestPart = parameters[i].getAnnotation(RequestPart.class)) != null) {
                apiParameter.name = requestPart.value();
                if (apiParameter.name.isEmpty()) {
                    apiParameter.name = requestPart.name();
                }
                apiParameter.required = requestPart.required();
                apiParameter.requestType = "file";
                api.contentType = "multipart/form-data;";
            }
            if ((requestBody = parameters[i].getAnnotation(RequestBody.class)) != null) {
                apiParameter.requestType = "textarea";
                api.contentType = "application/json; charset=utf-8";
            }
            if ((pathVariable = parameters[i].getAnnotation(PathVariable.class)) != null) {
                apiParameter.position = "query";
            }
            if (apiParameter.name == null || apiParameter.name.isEmpty()) {
                apiParameter.name = parameterNames[i];
                apiParameter.required = true;
            }
            apiParameter.type = parameters[i].getType().getName();
            apiParameterList.add(apiParameter);
        }
        return apiParameterList.toArray(new APIParameter[0]);
    }

    public static List<Class> scanPackageList() throws Exception {
        List classList = new ArrayList<Class>();
        for (String packageName : QuickAPIConfig.packageNames) {
            String packageNamePath = packageName.replace(".", "/");
            Enumeration<URL> urlEnumeration = Thread.currentThread().getContextClassLoader().getResources(packageNamePath);
            block9: while (urlEnumeration.hasMoreElements()) {
                URL url = urlEnumeration.nextElement();
                if (url == null) continue;
                switch (url.getProtocol()) {
                    case "file": {
                        File file = new File(url.getFile());
                        logger.info("[\u7c7b\u6587\u4ef6\u8def\u5f84]{}", (Object)file.getAbsolutePath());
                        if (!file.isDirectory()) {
                            throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                        }
                        Stack<File> stack = new Stack<File>();
                        stack.push(file);
                        String indexOfString = packageName.replace(".", "/");
                        while (!stack.isEmpty()) {
                            file = (File)stack.pop();
                            for (File f : file.listFiles()) {
                                if (f.isDirectory()) {
                                    stack.push(f);
                                    continue;
                                }
                                if (!f.isFile() || !f.getName().endsWith(".class")) continue;
                                String path = f.getAbsolutePath().replace("\\", "/");
                                int startIndex = path.indexOf(indexOfString);
                                String className = path.substring(startIndex, path.length() - 6).replace("/", ".");
                                classList.add(Class.forName(className));
                            }
                        }
                        continue block9;
                    }
                    case "jar": {
                        JarFile jarFile;
                        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                        if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) break;
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry jarEntry = jarEntries.nextElement();
                            String jarEntryName = jarEntry.getName();
                            if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class")) continue;
                            String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                            classList.add(Class.forName(className));
                        }
                        break;
                    }
                }
            }
        }
        if (classList.size() == 0) {
            logger.warn("[\u626b\u63cf\u5b9e\u4f53\u7c7b\u4fe1\u606f\u4e3a\u7a7a]");
            return classList;
        }
        Stream<Class> stream = classList.stream().filter(_class -> {
            boolean result = true;
            if (QuickAPIConfig.ignoreClassList != null && QuickAPIConfig.ignoreClassList.contains(_class)) {
                logger.warn("[\u5ffd\u7565\u7c7b\u540d]\u7c7b\u540d:{}!", (Object)_class.getName());
                result = false;
            }
            if (QuickAPIConfig.ignorePackageNameList != null) {
                for (String ignorePackageName : QuickAPIConfig.ignorePackageNameList) {
                    if (!_class.getName().contains(ignorePackageName)) continue;
                    logger.warn("[\u5ffd\u7565\u5305\u540d]\u5305\u540d:{}\u7c7b\u540d:{}", (Object)ignorePackageName, (Object)_class.getName());
                    result = false;
                }
            }
            return result;
        });
        if (QuickAPIConfig.predicate != null) {
            stream.filter(QuickAPIConfig.predicate);
        }
        classList = stream.collect(Collectors.toList());
        return classList;
    }
}

