function SetListBlockUpdateButtonTypeFlow(context){
    const listBlockContext = quickams.checkData(context, "listBlockContext");
    const listBlock = quickams.checkData(context, "listBlock");

    const buttonTypeList = listBlockContext["listBlockContextOption"]["buttonTypeList"];
    if(null==buttonTypeList||buttonTypeList.length===0){
        return;
    }
    if(buttonTypeList.indexOf("UPDATE")>=0){
        //添加更新按钮
        listBlock["operations"]["update"] = {
            "type": "button",
            "label": "编辑",
            "props":{
                "type": "warning",
            }
        };

        const responseFields = listBlockContext["resourceBlockContextOption"]["responseFields"];
        const updateDisplayFieldNames = listBlockContext["listBlockContextOption"]["updateDisplayFieldNames"];
        const updateDisableFieldNames = listBlockContext["listBlockContextOption"]["updateDisableFieldNames"];

        listBlock["actions"]["update"] = function(params){
            const resourceFields = this.resource.fields;
            const row = params.$prevReturn;

            let fields = {};
            for(let i=0;i<responseFields.length;i++){
                const fieldName = responseFields[i]["name"];
                if(null!=updateDisplayFieldNames&&updateDisplayFieldNames.indexOf(fieldName)<0){
                    continue;
                }
                fields[fieldName] = resourceFields[fieldName];
                if(!fields[fieldName].hasOwnProperty("props")){
                    fields[fieldName]["props"] = {};
                }
                if(null!=updateDisableFieldNames&&updateDisableFieldNames.indexOf(fieldName)>=0){
                    fields[fieldName]["props"]["disabled"] = "true";
                }else if(fields[fieldName]["type"]==="textarea"){
                    fields[fieldName]["props"]["resize"] = "none";
                }

                if(fields[fieldName]["type"]==="textarea"){
                    fields[fieldName]["props"]["rows"] = 8;
                }

                //修改select类型
                if(fields[fieldName]["type"]==="select"){
                    row[fieldName] = row[fieldName]+"";
                }

                //修改JSON类型值
                const fieldValue = row[fieldName];
                if (typeof (fieldValue) == "object" || typeof (fieldValue) == "array") {
                    row[fieldName] = JSON.stringify(fieldValue, null, '\t');
                }
            }
            let dialogOption = {
                "resource": {
                    "api": this.resource.api,
                    "fields": fields
                }
            };
            return this.callAction("@editItemDialog list:1", dialogOption);
        }
    }

}