function SetListBlockRequestFieldsFlow(context){
    const listBlockContext = quickams.checkData(context, "listBlockContext");
    const listBlock = quickams.checkData(context, "listBlock");

    let requestFields = listBlockContext["listBlockContextOption"]["requestFields"];

    for(let i=0;i<requestFields.length;i++){
        const requestField = requestFields[i];
        quickams.putData(context, "fieldContext", requestField);
        if(requestField["label"].indexOf("(")>0){
            SetSelectResourceFieldFlow(context);
        }else{
            SetGeneralResourceFieldFlow(context);
        }
        const resourceField = quickams.useData(context, "resourceField");

        const operationField = {
            "slot": "searchs",
            "type": "field",
            "label": resourceField["label"],
            "field": resourceField,
            "info": resourceField["info"]
        }
        listBlock["operations"][requestField["name"]] = operationField;
    }
}