function SetListBlockInitialSearchConditionFlow(context){
    const listBlockContext = quickams.checkData(context, "listBlockContext");
    const listBlock = quickams.checkData(context, "listBlock");

    const listBlockContextOption = listBlockContext["listBlockContextOption"];
    const openDialogFieldKeyName = "OpenDialog_"+listBlockContext["uniqueKey"];
    quickams.putData(context, "openDialogFieldKeyName", openDialogFieldKeyName);

    listBlock["actions"]["fieldChange"] = function({field,name,value,path}){
        if(field["type"]==="select"||field["type"]==="cascader"){
            this.callAction("list:1");
        }
    };

    listBlock["actions"]["initialCondition"] = function(){
        if(!this["block"]["options"].hasOwnProperty("dialog")){
            localStorage.removeItem(openDialogFieldKeyName);
        }
        this.callAction("setSearch");
        if(listBlockContextOption["initialList"]){
            this.callAction("list:1");
        }
    }

    listBlock["actions"]["setSearch"] = function(){
        let searchFields = Object.keys(this["fields"]);
        //打开弹窗字段
        {
            const fieldKeyNameString = localStorage.getItem(openDialogFieldKeyName);
            let routerPushFields = null;
            if(null!=fieldKeyNameString){
                routerPushFields = ams.utils.parseString(fieldKeyNameString);
            }
            for(let i=0;i<searchFields.length;i++){
                let value = ams.utils.getQueryString(searchFields[i]);
                if(null!=value&&value!==""){
                    value = decodeURIComponent(value);
                    this.$set(this["data"]["searchs"], [searchFields[i]], value);
                }else if(null!=routerPushFields&&routerPushFields.hasOwnProperty(searchFields[i])){
                    value = decodeURIComponent(routerPushFields[searchFields[i]]);
                    this.$set(this["data"]["searchs"], [searchFields[i]], value);
                }
            }
        }

        //页面跳转
        const routerPushKey = listBlockContext["uniqueKey"]+"_routerPushData";
        const blockRouterPushDataString = localStorage.getItem(routerPushKey);
        if(null!=blockRouterPushDataString){
            const blockRouterPushData = JSON.parse(blockRouterPushDataString);
            for(let i=0;i<searchFields.length;i++){
                const searchField = searchFields[i];
                if(blockRouterPushData.hasOwnProperty(searchField)){
                    this.$set(this["data"]["searchs"], searchField, blockRouterPushData[searchField]);
                }
            }
            localStorage.removeItem(routerPushKey);
        }
    }

    listBlock["operations"]["tableHeader"] = {
        "slot": "rightTop",
        "type": "filter",
        // "label": "表头管理",
        "props": {
            "type": "primary",
            "icon": "fa fa-list fa-lg"
        },
    }
    listBlock["operations"]["resetTableHeader"] = {
        "slot": "rightTop",
        "type": "button",
        // "label": "重置表头",
        "props": {
            "type": "primary",
            "icon": "fa fa-eraser fa-lg"
        },
        "event": "resetTableHeader"
    }
    listBlock["actions"]["resetTableHeader"] = function(){
        const key = "AMS_BLOCK_"+listBlockContext["uniqueKey"];
        localStorage.removeItem(key);
        location.reload();
    };
}