function SetListBlockOperationRequestButtonFlow(context){
    setOperation(context);
    setAction(context);

    function setOperation(context){
        const blockOperationContext = quickams.checkData(context, "blockOperationContext");
        const listBlock = quickams.checkData(context, "listBlock");
        const index = quickams.checkData(context, "index");

        let event = blockOperationContext["confirm"]?("confirm:确认执行"+blockOperationContext["label"]+"吗? "):"";
        event += "operationAction"+index;
        event += blockOperationContext["refreshList"]?" list:1":"";
        let operation = {
            "type": "button",
            "label": blockOperationContext["label"],
            "props":{
                "type": blockOperationContext["buttonType"],
            },
            "event": event
        };
        quickams.putData(context, "operationButton", operation);
        SetOperationShowFunctionFlow(context);
        if(null!=blockOperationContext["icon"]){
            operation["props"]["icon"] = blockOperationContext["icon"]+" fa fa-lg";
        }

        //按钮位置
        switch (blockOperationContext["position"]){
            case "None":{
                operation["show"] = function (){
                    return false;
                }
            }break;
            case "Row":{}break;
            case "MultipleSelect":{
                operation["slot"] = "multipleSelect";
            }break;
            case "RightTop":{
                operation["slot"] = "rightTop";
            }break;
            case "Search":{
                operation["slot"] = "searchs";
            }break;
        }

        listBlock["operations"]["operationButton"+index] = operation;
    }

    function setAction(context){
        const listBlockContext = quickams.checkData(context, "listBlockContext");
        const blockOperationContext = quickams.checkData(context, "blockOperationContext");
        const listBlock = quickams.checkData(context, "listBlock");
        const index = quickams.checkData(context, "index");

        const resourceBlockOption = listBlockContext["resourceBlockContextOption"];

        const action = function(params){
            let listBlockRequest = {
                "label": blockOperationContext["label"]
            };

            switch (blockOperationContext["position"]){
                case "None":{}break;
                case "Row":{
                    listBlockRequest["row"] = params.$prevReturn;
                    listBlockRequest["search"] = this.data.searchs;
                }break;
                case "MultipleSelect":{
                    listBlockRequest["array"] = params.$prevReturn;
                    listBlockRequest["search"] = this.data.searchs;
                }break;
                case "RightTop":
                case "Search":{
                    const search = ams.utils.parseString(location.search);
                    for(let prop in this.data.searchs){
                        search[prop] = this.data.searchs[prop];
                    }
                    listBlockRequest["search"] = search;
                }break;
            }

            if("条件删除"===listBlockRequest["label"]){
                let showErrorMessage = true;
                for(let prop in listBlockRequest["search"]){
                    if(typeof(listBlockRequest["search"][prop])!=="undefined"){
                        showErrorMessage = false;
                    }
                }
                if(showErrorMessage){
                    this.$message.error("请先设置查询条件");
                    return;
                }
            }

            let opt = {
                "method": "post",
                "url": "/ams/api/"+resourceBlockOption["apiPrefix"]+"/userOperation",
                "data": listBlockRequest,
                "params":{},
                "headers":{},
                "withCredentials":true,
                "contentType": "json"
            };

            const activeBlock = this;
            activeBlock.showLoading();
            return ams.request(opt).then((response) => {
                if (response.data.code !== 0) {
                    if(null==response.data.msg){
                        activeBlock.$message.error("后台服务异常!错误码:"+response.data.code);
                    }else{
                        activeBlock.$message.error("后台服务异常!错误码:"+response.data.code+",提示信息:"+response.data.msg);
                    }
                    return;
                }
                const data = response.data.data;
                if(blockOperationContext["copyResult"]){
                    quickams.setClipBoard({"value":JSON.stringify(data)});
                }
                if(blockOperationContext["showCustomerMessage"]){
                    const type = data["type"];
                    const message = data["message"];
                    //用户自定义信息
                    switch (type){
                        case "primary":{
                            activeBlock.$message.success(message);
                        }break;
                        case "success":{
                            activeBlock.$message.success(message);
                        }break;
                        case "warning":{
                            activeBlock.$message.warning(message);
                        }break;
                        case "danger":{
                            activeBlock.$message.error(message);
                        }break;
                    }
                }else{
                    activeBlock.$message.success(blockOperationContext["label"]+"执行完毕");
                }
            }).finally(() => {
                activeBlock.hideLoading();
            });
        };

        listBlock["actions"]["operationAction"+index] = action;
    }
}