function SetListBlockOperationDialogButtonFlow(context){
    setDialogBlock(context);
    setOperation(context);
    setAction(context);

    function setDialogBlock(context){
        const blockOperationContext = quickams.checkData(context, "blockOperationContext");
        const listBlock = quickams.checkData(context, "listBlock");
        const index = quickams.checkData(context, "index");
        const listBlockName = quickams.checkData(context, "listBlockName");

        let scopeContext = {
            "specificBlockName": blockOperationContext["routerBlockName"],
            "listBlockContextList": context["listBlockContextList"],
        };
        GetSpecificListBlockFlow(scopeContext);

        const scopeListBlock = quickams.checkData(scopeContext, "listBlock");
        scopeListBlock["options"]["dialog"] = true;
        listBlock["blocks"][listBlockName+"_dialog"+index] = {
            "type": "dialog",
            "props": {
                "append-to-body": true
            },
            "blocks": {}
        };
        listBlock["blocks"][listBlockName+"_dialog"+index]["blocks"][listBlockName+"_dialogContent"+index] = scopeListBlock;
    }

    function setOperation(context){
        const blockOperationContext = quickams.checkData(context, "blockOperationContext");
        const listBlock = quickams.checkData(context, "listBlock");
        const index = quickams.checkData(context, "index");

        let operation = {
            "type": "button",
            "label": blockOperationContext["label"],
            "props":{
                "type": blockOperationContext["buttonType"],
            },
            "event": "operationAction"+index
        };
        quickams.putData(context, "operationButton", operation);
        SetOperationShowFunctionFlow(context);

        listBlock["operations"]["operationButton"+index] = operation;
    }

    function setAction(context){
        const blockOperationContext = quickams.checkData(context, "blockOperationContext");
        const listBlock = quickams.checkData(context, "listBlock");
        const index = quickams.checkData(context, "index");
        const openDialogFieldKeyName = "OpenDialog_"+blockOperationContext["routerBlockName"];
        const listBlockName = quickams.checkData(context, "listBlockName");

        const action = function(params){
            const routerFieldNameMap = blockOperationContext["routerFieldNameMap"];
            let searchData = {};
            for(let prop in routerFieldNameMap){
                searchData[routerFieldNameMap[prop]] = params.$prevReturn[prop];
            }
            localStorage.setItem(openDialogFieldKeyName, ams.param(searchData));
            this.callAction(listBlockName+"_dialog"+index+".show");
        };

        listBlock["actions"]["operationAction"+index] = action;
    }
}