function SetFormBlockOperationRequestButtonFlow(context){
    setOperation(context);
    setAction(context);

    function setOperation(context){
        const formBlockOperationContext = quickams.checkData(context, "formBlockOperationContext");
        const formBlock = quickams.checkData(context, "formBlock");
        const index = quickams.checkData(context, "index");

        let event = formBlockOperationContext["confirm"]?("confirm:确认执行"+formBlockOperationContext["label"]+"吗? "):"";
        event += "operationAction"+index;
        let operation = {
            "type": "button",
            "label": formBlockOperationContext["label"],
            "props":{
                "type": formBlockOperationContext["buttonType"],
            },
            "event": event
        };

        quickams.putData(context, "operationButton", operation);
        quickams.putData(context, "blockOperationContext", formBlockOperationContext);
        SetOperationShowFunctionFlow(context);

        if(null!=formBlockOperationContext["icon"]){
            operation["props"]["icon"] = formBlockOperationContext["icon"]+" fa fa-lg";
        }
        formBlock["operations"]["operationButton"+index] = operation;
    }

    function setAction(context){
        const formBlockContext = quickams.checkData(context, "formBlockContext");
        const formBlockOperationContext = quickams.checkData(context, "formBlockOperationContext");
        const formBlock = quickams.checkData(context, "formBlock");
        const index = quickams.checkData(context, "index");

        const action = function(params){
            let formBlockRequest = {
                "label": formBlockOperationContext["label"],
                "data": params.$prevReturn
            };

            let opt = {
                "method": "post",
                "url": "/ams/api/"+formBlockContext["apiPrefix"]+"/userOperation",
                "data": formBlockRequest,
                "params":{},
                "headers":{},
                "withCredentials":true,
                "contentType": "json"
            };

            const activeBlock = this;
            activeBlock.showLoading();
            return ams.request(opt).then((response) => {
                if (response.data.code !== 0) {
                    if(null==response.data.msg){
                        activeBlock.$message.error("后台服务异常!错误码:"+response.data.code);
                    }else{
                        activeBlock.$message.error("后台服务异常!错误码:"+response.data.code+",提示信息:"+response.data.msg);
                    }
                    return;
                }
                if(formBlockOperationContext["copyResult"]){
                    let data = response.data.data;
                    quickams.setClipBoard({"value":JSON.stringify(data)});
                }
                const responseData = response.data.data;
                for(let prop in responseData){
                    this.$set(this["data"], prop, responseData[prop]);
                }
                activeBlock.$message.success(formBlockOperationContext["label"]+"执行完毕");
            }).finally(() => {
                activeBlock.hideLoading();
            });
        };

        formBlock["actions"]["operationAction"+index] = action;
    }
}