/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.module.config.bean;

import cn.schoolwow.ams.domain.option.QuickAMSOption;
import java.io.IOException;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AMSBasicAuthInterceptor
implements HandlerInterceptor {
    @Autowired
    private QuickAMSOption quickAMSOption;
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BASIC_AUTH_PREFIX = "Basic ";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (StringUtils.isBlank((CharSequence)this.quickAMSOption.username) || StringUtils.isBlank((CharSequence)this.quickAMSOption.password)) {
            return true;
        }
        String authorizationHeader = request.getHeader(AUTHORIZATION_HEADER);
        if (authorizationHeader == null || !authorizationHeader.startsWith(BASIC_AUTH_PREFIX)) {
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "Basic realm=\"Restricted\"");
            response.getWriter().write("BasicAuth\u8ba4\u8bc1\u5931\u8d25");
            return false;
        }
        String credentials = authorizationHeader.substring(BASIC_AUTH_PREFIX.length()).trim();
        byte[] decodedBytes = Base64.getDecoder().decode(credentials);
        String decodedCredentials = new String(decodedBytes);
        int colonIndex = decodedCredentials.indexOf(58);
        if (colonIndex == -1 || !decodedCredentials.substring(0, colonIndex).equals(this.quickAMSOption.username) || !decodedCredentials.substring(colonIndex + 1).equals(this.quickAMSOption.password)) {
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "Basic realm=\"Restricted\"");
            response.getWriter().write("BasicAuth\u8ba4\u8bc1\u7684\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
            return false;
        }
        return true;
    }
}

