ams.utils.jsonView = function (val, field, row) {
    if (null == val) {
        return;
    }
    if (typeof (val) == "object" || typeof (val) == "array") {
        val = JSON.stringify(val);
    }
    if (val.length > 50) {
        //显示前20个和后30个字符
        return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
    }
    return val;
};

ams.utils.jsonGet = function (val, field, row) {
    if (null == val) {
        return;
    }
    if (typeof (val) == "object" || typeof (val) == "array") {
        val = JSON.stringify(val);
    }
    return val;
};

ams.config({
    "resource": {
        requestInterceptor(options) {
            if (options.url.indexOf("?") > 0) {
                options.url += "&t=" + new Date().getTime();
            } else {
                options.url += "?t=" + new Date().getTime();
            }
            return options;
        },
        errorInterceptor() {
            return arguments[0]["response"];
        },
        "api": {
            "contentType": "json"
        }
    },
    "defaultFieldConfig": {
        "text": {
            "style": {
                "cursor": "pointer"
            },
            "view": ams.utils.jsonView,
            "get": ams.utils.jsonGet
        },
        "textarea": {
            "style": {
                "cursor": "pointer"
            },
            "view": ams.utils.jsonView,
            "get": ams.utils.jsonGet
        },
        "link":{
            "style": {
                "color": "blue"
            },
            "props": {
                "href": function(e) {
                    return e;
                },
                "target": "_blank"
            },
            "view": ams.utils.jsonView,
            "get": ams.utils.jsonGet
        }
    },
});

ams.action("refreshExtraData", function(){
    ams.request({
        "method": "GET",
        "url": "/ams/refreshExtraData?projectName="+projectName
    }).then(response=>{
        ams.blockConfig["extraData"] = response.data.data;
    })
});