package cn.schoolwow.ams.module.listener.operation.flow;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationButton;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class OperationDispatcherFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setAMSOperationButton(flowContext);
        executeHandleOperation(flowContext);
    }

    @Override
    public String name() {
        return "ams操作分发";
    }

    private void setAMSOperationButton(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        String methodName = (String) flowContext.checkData("methodName");

        switch (daoName){
            case "clazz":{
                List<AMSClazzConfig> amsClazzConfigList = (List<AMSClazzConfig>) flowContext.getData("amsClazzConfigList");
                if(null==amsClazzConfigList||amsClazzConfigList.isEmpty()){
                    throw new IllegalArgumentException("不支持的自定义类操作!项目名:"+projectName+",自定义类名:"+tableName+",方法名:"+methodName);
                }
                for(AMSClazzConfig amsClazzConfig:amsClazzConfigList){
                    if(!amsClazzConfig.projectName.equalsIgnoreCase(projectName)){
                        continue;
                    }
                    if(!amsClazzConfig.clazzName.equalsIgnoreCase(tableName)){
                        continue;
                    }
                    for(AMSOperationButton amsOperationButton:amsClazzConfig.amsOperationButtonList){
                        if(amsOperationButton.methodName.equalsIgnoreCase(methodName)){
                            flowContext.putCurrentFlowData("amsOperationButton", amsOperationButton);
                            return;
                        }
                    }
                }
            }break;
            default:{
                List<AMSTableConfig> amsTableConfigList = (List<AMSTableConfig>) flowContext.getData("amsTableConfigList");
                if(null==amsTableConfigList||amsTableConfigList.isEmpty()){
                    throw new IllegalArgumentException("不支持的操作!项目名:"+projectName+",数据库名:"+daoName+",表名:"+tableName+",方法名:"+methodName);
                }
                for(AMSTableConfig amsTableConfig:amsTableConfigList){
                    if(!amsTableConfig.projectName.equalsIgnoreCase(projectName)){
                        continue;
                    }
                    if(!amsTableConfig.daoName.equalsIgnoreCase(daoName)){
                        continue;
                    }
                    if(!amsTableConfig.entity.clazz.getSimpleName().equalsIgnoreCase(tableName)
                            &&!amsTableConfig.tableName.equalsIgnoreCase(tableName)){
                        continue;
                    }
                    for(AMSOperationButton amsOperationButton:amsTableConfig.amsOperationButtonList){
                        if(amsOperationButton.methodName.equalsIgnoreCase(methodName)){
                            flowContext.putCurrentFlowData("amsOperationButton", amsOperationButton);
                            return;
                        }
                    }
                }
            }break;
        }
    }

    private void executeHandleOperation(FlowContext flowContext) throws Exception {
        AMSOperationButton amsOperationButton = (AMSOperationButton) flowContext.checkData("amsOperationButton");
        String methodName = (String) flowContext.checkData("methodName");
        JSONObject requestBody = (JSONObject) flowContext.getData("requestBody");

        if(null!=amsOperationButton.fieldNameList&&amsOperationButton.fieldNameList.length>0){
            if(AMSOperationPosition.MultipleSelect.equals(amsOperationButton.position)){
                if(amsOperationButton.fieldNameList.length==1){
                    Validate.isTrue(requestBody.containsKey(amsOperationButton.fieldNameList[0]+"List"), amsOperationButton.fieldNameList[0]+"字段不能为空");
                    Validate.notEmpty(requestBody.getJSONArray(amsOperationButton.fieldNameList[0]+"List"), "字段不能为空");
                }else{
                    Validate.isTrue(requestBody.containsKey("list"), "参数列表不能为空");
                    Validate.notEmpty(requestBody.getJSONArray("list"), "参数列表不能为空");
                }
            }else{
                for(String fieldName:amsOperationButton.fieldNameList){
                    Validate.isTrue(requestBody.containsKey(fieldName), fieldName+"参数不能为空");
                }
            }
        }
        if(null!=amsOperationButton.searchFieldNameList&&amsOperationButton.searchFieldNameList.length>0){
            Validate.isTrue(requestBody.containsKey("searchs"), "查询字段数据不能为空!");
            JSONObject searchs = requestBody.getJSONObject("searchs");
            for(String searchFieldName:amsOperationButton.searchFieldNameList){
                Validate.isTrue(searchs.containsKey(searchFieldName), "查询字段["+searchFieldName+"]字段的值不能为空");
            }
        }
        JSONObject response = amsOperationButton.handleOperation.handle(methodName, requestBody);
        flowContext.putData("response", response);
    }
}
