package cn.schoolwow.ams.module.initial.flow.set.resource;

import cn.schoolwow.ams.domain.listener.select.AMSRemoteSelect;
import cn.schoolwow.ams.module.initial.flow.set.operation.SetRemoteSelectOperationFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

import java.util.ArrayList;
import java.util.List;

public class SetTableRemoteSelectFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<AMSRemoteSelect> amsRemoteSelectList = (List<AMSRemoteSelect>) flowContext.getData("amsRemoteSelectList");
        if(null==amsRemoteSelectList||amsRemoteSelectList.isEmpty()){
            return;
        }
        List<AMSRemoteSelect> remoteSelectContextList = (List<AMSRemoteSelect>) flowContext.getData("remoteSelectContextList", new ArrayList<>());
        String className = (String) flowContext.checkData("className");

        for(AMSRemoteSelect amsRemoteSelect:amsRemoteSelectList){
            //校验
            {
                Validate.notEmpty(amsRemoteSelect.type, "下拉框类型不能为空!涉及类名:"+className);
                Validate.notEmpty(amsRemoteSelect.name, "下拉框字段名不能为空!涉及类名:"+className);
                Validate.notEmpty(amsRemoteSelect.label, "下拉框显示名称不能为空!涉及类名:"+className);
                Validate.notNull(amsRemoteSelect.getRemoteOption, "获取远程下拉框选项函数不能为空!涉及类名:"+className);
            }

            flowContext.startFlow(new SetRemoteSelectOperationFlow())
                    .putCurrentCompositeFlowData("amsRemoteSelect", amsRemoteSelect)
                    .execute();
            remoteSelectContextList.add(amsRemoteSelect);
        }
    }

    @Override
    public String name() {
        return "设置远程下拉框列表";
    }
}
