package cn.schoolwow.ams.module.initial.flow.set.resource;

import cn.schoolwow.ams.domain.listener.list.ListBlockOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class SetListBlockOptionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ListBlockOption listBlockOption = (ListBlockOption) flowContext.getData("listBlockOption");
        if(null==listBlockOption){
            return;
        }

        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");
        JSONObject blockConfig = matchBlock.getJSONObject("blockConfig");

        if(null!=listBlockOption.idField){
            matchBlock.put("id", listBlockOption.idField);
        }
        matchBlock.put("initList", listBlockOption.initList);
        if(StringUtils.isNoneBlank(listBlockOption.sortField)){
            JSONObject data = new JSONObject();
            JSONObject searchs = new JSONObject();
            searchs.put("sortField", listBlockOption.sortField);
            searchs.put("sortOrder", listBlockOption.sortOrder);
            data.put("searchs", searchs);
            blockConfig.put("data", data);
        }
        if(null!=listBlockOption.simulate&&listBlockOption.simulate){
            blockConfig.put("pageSize", 10);
            JSONObject props = new JSONObject();
            props.put("pagination", "simulate");
            blockConfig.put("props", props);
        }
    }

    @Override
    public String name() {
        return "设置列表配置项";
    }

}
