package cn.schoolwow.ams.module.initial.flow.set.operation;

import cn.schoolwow.ams.domain.listener.routerpush.AMSRouterPush;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class SetRouterPushButtonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        AMSRouterPush amsRouterPush = (AMSRouterPush) flowContext.checkData("amsRouterPush");
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");
        if(!matchBlock.containsKey("routerPushMap")){
            matchBlock.put("routerPushMap", new JSONObject());
        }
        {
            JSONObject routerPush = new JSONObject();
            routerPush.put("name", amsRouterPush.name);
            routerPush.put("label", amsRouterPush.label);
            routerPush.put("path", amsRouterPush.path);
            routerPush.put("fieldNameMap", amsRouterPush.fieldNameMap);
            matchBlock.getJSONObject("routerPushMap").put(amsRouterPush.name, routerPush);
        }
        {
            JSONObject operationField = new JSONObject();
            operationField.put("type", "button");
            operationField.put("label", amsRouterPush.label);
            {
                JSONObject props = new JSONObject();
                props.put("type", "primary");
                operationField.put("props", props);
            }
            operationField.put("event", "routerPushOperation:"+amsRouterPush.name);

            matchBlock.getJSONObject("operationFields").put(amsRouterPush.name, operationField);
        }
    }

    @Override
    public String name() {
        return "设置页面跳转按钮";
    }

}
