package cn.schoolwow.ams.module.initial.flow.set.field.table;

import cn.schoolwow.ams.domain.listener.table.AMSTableListener;
import cn.schoolwow.ams.domain.listener.table.ListTableField;
import cn.schoolwow.ams.module.initial.flow.set.field.common.GetBasicResourceFieldFlow;
import cn.schoolwow.ams.module.initial.flow.set.field.common.GetOperationFieldFlow;
import cn.schoolwow.ams.module.initial.flow.set.field.common.GetSelectResourceFieldFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class SetAMSTableListTableFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        AMSTableListener amsTableListener = (AMSTableListener) flowContext.getData("amsTableListener");
        if(null==amsTableListener||null==amsTableListener.listTable){
            return;
        }
        ListTableField[] listTableFields = amsTableListener.listTable.listTableFieldArray();
        for(ListTableField listTableField:listTableFields){
            setOperationField(listTableField, flowContext);
            if(listTableField.resourceField){
                setResourceField(listTableField, flowContext);
            }
        }
    }

    @Override
    public String name() {
        return "设置数据库表关联查询字段列表";
    }

    private void setResourceField(ListTableField listTableField, FlowContext flowContext){
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        if(listTableField.label.contains("(")){
            JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetSelectResourceFieldFlow())
                    .putCurrentCompositeFlowData("comment", listTableField.label)
                    .execute()
                    .checkData("resourceField");
            matchBlock.getJSONObject("resourceFields").put(listTableField.name, resourceField);
        }else{
            JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetBasicResourceFieldFlow())
                    .putCurrentCompositeFlowData("comment", listTableField.label)
                    .putCurrentCompositeFlowData("amsType", listTableField.type)
                    .execute()
                    .checkData("resourceField");
            matchBlock.getJSONObject("resourceFields").put(listTableField.name, resourceField);
        }
    }

    private void setOperationField(ListTableField listTableField, FlowContext flowContext){
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        if(listTableField.label.contains("(")){
            JSONObject operationField = (JSONObject) flowContext.startFlow(new GetSelectResourceFieldFlow())
                    .next(new GetOperationFieldFlow())
                    .putCurrentCompositeFlowData("comment", listTableField.label)
                    .execute()
                    .checkData("operationField");
            matchBlock.getJSONObject("operationFields").put(listTableField.name, operationField);
        }else{
            JSONObject operationField = (JSONObject) flowContext.startFlow(new GetTableBasicResourceFieldFlow())
                    .next(new GetOperationFieldFlow())
                    .putCurrentCompositeFlowData("comment", listTableField.label)
                    .putCurrentCompositeFlowData("amsType", listTableField.type)
                    .execute()
                    .checkData("operationField");
            matchBlock.getJSONObject("operationFields").put(listTableField.name, operationField);
        }
    }
}
