package cn.schoolwow.ams.module.initial.flow.set.field.table;

import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.ams.domain.listener.list.ListBlockOption;
import cn.schoolwow.ams.module.initial.flow.set.field.common.GetOperationFieldFlow;
import cn.schoolwow.ams.module.initial.flow.set.field.common.GetSelectResourceFieldFlow;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class SetAMSTableFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setRequestFields(flowContext);
        setResponseFields(flowContext);
    }

    @Override
    public String name() {
        return "设置数据库表请求和响应字段";
    }

    private void setRequestFields(FlowContext flowContext) {
        AMSTableConfig amsTableConfig = (AMSTableConfig) flowContext.checkData("amsTableConfig");
        ListBlockOption listBlockOption = (ListBlockOption) flowContext.getData("listBlockOption");

        if(null==listBlockOption||null==listBlockOption.requestFieldNames){
            for (Property property : amsTableConfig.entity.properties) {
                if (!property.column.equalsIgnoreCase("id") && (null == property.comment || property.comment.isEmpty())) {
                    continue;
                }
                if (property.column.equalsIgnoreCase("id")) {
                    property.comment = "id";
                }
                setResourceField(property, flowContext);
            }
        }else{
            for(String requestFieldName:listBlockOption.requestFieldNames){
                Property property = amsTableConfig.entity.getPropertyByFieldNameOrColumnName(requestFieldName);
                setResourceField(property, flowContext);
            }
        }
    }

    private void setResponseFields(FlowContext flowContext) {
        AMSTableConfig amsTableConfig = (AMSTableConfig) flowContext.checkData("amsTableConfig");
        ListBlockOption listBlockOption = (ListBlockOption) flowContext.getData("listBlockOption");

        if(null==listBlockOption||null==listBlockOption.responseFieldNames){
            for (Property property : amsTableConfig.entity.properties) {
                if (!property.column.equalsIgnoreCase("id") && (null == property.comment || property.comment.isEmpty())) {
                    continue;
                }
                if (property.column.equalsIgnoreCase("id")) {
                    property.comment = "id";
                }
                setOperationField(property, flowContext);
            }
        }else{
            for(String responseFieldName:listBlockOption.responseFieldNames){
                Property property = amsTableConfig.entity.getPropertyByFieldNameOrColumnName(responseFieldName);
                setOperationField(property, flowContext);
            }
        }
    }

    private void setResourceField(Property property, FlowContext flowContext){
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        String comment = property.comment;
        String name = StringUtil.underline2Camel(property.column);
        if(comment.contains("(")){
            JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetSelectResourceFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .execute()
                    .checkData("resourceField");
            matchBlock.getJSONObject("resourceFields").put(name, resourceField);
        }else{
            JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetTableBasicResourceFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .putCurrentCompositeFlowData("property", property)
                    .execute()
                    .checkData("resourceField");
            matchBlock.getJSONObject("resourceFields").put(name, resourceField);
        }
    }

    private void setOperationField(Property property, FlowContext flowContext){
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        String comment = property.comment;
        String name = StringUtil.underline2Camel(property.column);
        if(comment.contains("(")){
            JSONObject operationField = (JSONObject) flowContext.startFlow(new GetSelectResourceFieldFlow())
                    .next(new GetOperationFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .execute()
                    .checkData("operationField");
            matchBlock.getJSONObject("operationFields").put(name, operationField);
        }else{
            JSONObject operationField = (JSONObject) flowContext.startFlow(new GetTableBasicResourceFieldFlow())
                    .next(new GetOperationFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .putCurrentCompositeFlowData("property", property)
                    .execute()
                    .checkData("operationField");
            matchBlock.getJSONObject("operationFields").put(name, operationField);
        }
    }
}
