package cn.schoolwow.ams.module.initial.flow.set.field.table;

import cn.schoolwow.ams.domain.annotation.AMSColumnType;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class GetTableBasicResourceFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setByProperty(flowContext);
        setByAMSType(flowContext);
    }

    @Override
    public String name() {
        return "获取数据库表一般字段信息";
    }

    private void setByProperty(FlowContext flowContext){
        Property property = (Property) flowContext.getData("property");
        if(null==property){
            return;
        }
        String comment = (String) flowContext.checkData("comment");

        JSONObject field = new JSONObject();
        field.put("label", comment);
        field.put("info", "请输入" + comment);
        field.put("type", "text");
        if(null!=property.field){
            AMSColumnType amsColumnType = property.field.getAnnotation(AMSColumnType.class);
            if(null!=amsColumnType){
                field.put("type", amsColumnType.value());
            }
        }else{
            if (property.columnType.contains("date") || property.columnType.contains("timestamp")) {
                field.put("type", "datetime");
            } else if(property.comment.startsWith("是否")){
                field.put("type", "switch");
            }else if(property.column.contains("url")){
                field.put("type", "link");
            }
        }
        JSONObject props = new JSONObject();
        props.put("placeholder", "请输入" + comment);
        field.put("props", props);

        flowContext.putReturnData("resourceField", field);
    }

    private void setByAMSType(FlowContext flowContext){
        String amsType = (String) flowContext.getData("amsType");
        if(null==amsType){
            return;
        }
        String comment = (String) flowContext.checkData("comment");

        JSONObject field = new JSONObject();
        field.put("label", comment);
        field.put("info", "请输入" + comment);
        field.put("type", amsType);

        JSONObject props = new JSONObject();
        props.put("placeholder", "请输入" + comment);
        field.put("props", props);

        flowContext.putReturnData("resourceField", field);
    }
}
