package cn.schoolwow.ams.module.initial.flow.set.field.common;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class GetSelectResourceFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String comment = (String) flowContext.checkData("comment");

        JSONObject field = new JSONObject();
        String fieldComment = comment.substring(0, comment.indexOf("("));
        field.put("label", fieldComment);
        field.put("info", "请选择" + fieldComment);
        field.put("type", "select");

        JSONObject props = new JSONObject();
        field.put("props", props);
        props.put("placeholder", "请选择" + fieldComment);
        props.put("clearable", true);
        props.put("multiple", false);

        JSONObject options = new JSONObject();
        props.put("options", options);

        String selectText = comment.substring(comment.indexOf("(") + 1, comment.indexOf(")"));
        String[] tokens = selectText.split(",");
        for (String token : tokens) {
            int indexOf = token.indexOf(":");
            if (indexOf < 0) {
                throw new IllegalArgumentException("注释异常,非标准下拉框格式!注释:" + comment);
            }
            String key = token.substring(0, indexOf);
            String value = token.substring(indexOf + 1);
            options.put(key, value + "(" + key + ")");
        }
        flowContext.putReturnData("resourceField", field);
    }

    @Override
    public String name() {
        return "获取下拉框字段信息";
    }
}
