package cn.schoolwow.ams.module.initial.flow.set.dialog;

import cn.schoolwow.ams.domain.listener.dialog.AMSDialog;
import cn.schoolwow.ams.domain.listener.dialog.EditBlockItemDialogOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class SetUpdateButtonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        AMSDialog amsDialog = (AMSDialog) flowContext.checkData("amsDialog");

        if(null==amsDialog.editBlockItemDialogOption){
            return;
        }
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");
        JSONObject itemDialog = matchBlock.getJSONObject("itemDialog");
        JSONObject operationFields = matchBlock.getJSONObject("operationFields");

        EditBlockItemDialogOption editBlockItemDialogOption = amsDialog.editBlockItemDialogOption;

        JSONObject operationField = new JSONObject();
        {
            operationField.put("type", "button");
            operationField.put("label", "更新");
            {
                JSONObject props = new JSONObject();
                props.put("type", "warning");
                operationField.put("props", props);
            }
            operationField.put("event", "editBlockItemDialog list:1");
        }
        operationFields.put("editShopSupplyItemDialogButton", operationField);
        itemDialog.put("editBlockItemDialogOption", editBlockItemDialogOption);
    }

    @Override
    public String name() {
        return "设置弹窗-设置更新按钮";
    }
}
