package cn.schoolwow.ams.module.initial.flow.set.dialog;

import cn.schoolwow.ams.domain.listener.dialog.AMSDialog;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class SetDeleteButtonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        AMSDialog amsDialog = (AMSDialog) flowContext.checkData("amsDialog");

        if(null==amsDialog.deleteField){
            return;
        }
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");
        JSONObject operationFields = matchBlock.getJSONObject("operationFields");

        String deleteField = amsDialog.deleteField;
        if(null==deleteField||deleteField.isEmpty()){
            return;
        }
        //添加删除按钮
        {
            JSONObject operationField = new JSONObject();
            operationField.put("type", "button");
            operationField.put("label", "删除");
            {
                JSONObject props = new JSONObject();
                props.put("type", "danger");
                operationField.put("props", props);
            }
            operationField.put("event", "confirm:确认删除吗? deleteRecord:"+deleteField+" list:1");
            operationFields.put("deleteButton", operationField);
        }
        //添加批量删除按钮
        {
            JSONObject operationField = new JSONObject();
            operationField.put("slot", "multipleSelect");
            operationField.put("type", "button");
            operationField.put("label", "批量删除");
            {
                JSONObject props = new JSONObject();
                props.put("type", "danger");
                operationField.put("props", props);
            }
            operationField.put("event", "confirm:确认批量删除吗? deleteRecord:"+deleteField+" list:1");
            operationFields.put("multipleDeleteButton", operationField);
        }
    }

    @Override
    public String name() {
        return "设置弹窗-设置删除按钮";
    }
}
