package cn.schoolwow.ams.module.initial.flow.set.dialog;

import cn.schoolwow.ams.domain.listener.dialog.AMSDialog;
import cn.schoolwow.ams.domain.listener.dialog.AddBlockItemDialogOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

public class SetAddButtonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        AMSDialog amsDialog = (AMSDialog) flowContext.checkData("amsDialog");

        if(null==amsDialog.addBlockItemDialogOption){
            return;
        }
        String label = (String) flowContext.checkData("label");
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");
        JSONObject itemDialog = matchBlock.getJSONObject("itemDialog");
        JSONObject operationFields = matchBlock.getJSONObject("operationFields");

        AddBlockItemDialogOption addBlockItemDialogOption = amsDialog.addBlockItemDialogOption;
        String[] addFieldNameList = addBlockItemDialogOption.addFieldNameList;
        Validate.notEmpty(addFieldNameList, "待添加字段不能为空!涉及类名:"+amsDialog.getClass().getName());

        JSONObject operationField = new JSONObject();
        {
            operationField.put("type", "button");
            operationField.put("slot", "rightTop");
            operationField.put("label", "新增"+label);
            {
                JSONObject props = new JSONObject();
                props.put("type", "primary");
                operationField.put("props", props);
            }
            operationField.put("event", "addBlockItemDialog list:1");
        }
        operationFields.put("addBlockItemDialogButton", operationField);

        itemDialog.put("addBlockItemDialogOption", addBlockItemDialogOption);
    }

    @Override
    public String name() {
        return "设置弹窗-设置新增按钮";
    }
}
