package cn.schoolwow.ams.module.initial.flow.get;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.module.initial.flow.set.common.GetMatchBlockFlow;
import cn.schoolwow.ams.module.initial.flow.set.field.clazz.SetAMSClazzFieldFlow;
import cn.schoolwow.ams.module.initial.flow.set.operation.SetCopyFieldButtonFlow;
import cn.schoolwow.ams.module.initial.flow.set.resource.*;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetAMSClazzConfigFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<AMSClazzConfig> amsClazzConfigList = (List<AMSClazzConfig>) flowContext.getData("amsClazzConfigList");
        if(null==amsClazzConfigList||amsClazzConfigList.isEmpty()){
            return;
        }

        for(AMSClazzConfig amsClazzConfig:amsClazzConfigList){
            flowContext.startFlow("设置单个自定义表资源信息")
                    .putCurrentCompositeFlowData("projectName", amsClazzConfig.projectName)
                    .putCurrentCompositeFlowData("className", amsClazzConfig.getClass().getName())
                    .putCurrentCompositeFlowData("label", amsClazzConfig.label)
                    .putCurrentCompositeFlowData("amsClazzConfig", amsClazzConfig)
                    .putCurrentCompositeFlowData("listBlockOption", amsClazzConfig.listBlockOption)
                    .putCurrentCompositeFlowData("amsRemoteSelectList", amsClazzConfig.amsRemoteSelectList)
                    .putCurrentCompositeFlowData("amsDialog", amsClazzConfig.amsDialog)
                    .putCurrentCompositeFlowData("amsRouterPushList", amsClazzConfig.amsRouterPushList)
                    .putCurrentCompositeFlowData("copyFieldCommentMap", amsClazzConfig.copyFieldCommentMap)
                    .putCurrentCompositeFlowData("amsOperationButtonList", amsClazzConfig.amsOperationButtonList)
                    .next(new GetMatchBlockFlow())
                    .next(new SetAMSClazzFieldFlow())
                    .next(new SetListBlockOptionFlow())
                    .next(new SetTableDialogFlow())
                    .next(new SetTableRouterPushFlow())
                    .next(new SetCopyFieldButtonFlow())
                    .next(new SetAMSOperationButtonFlow())
                    .next(new SetTableRemoteSelectFlow())
                    .execute();
        }
    }

    @Override
    public String name() {
        return "设置自定义类资源信息";
    }

}
