package cn.schoolwow.ams.module.initial.flow.get;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.domain.list.AMSClazzConfigAware;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class GetAMSClazzConfigListFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<AMSClazzConfigAware> amsClazzConfigAwareList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if(null==amsClazzConfigAwareList||amsClazzConfigAwareList.isEmpty()){
            return;
        }
        List<AMSClazzConfig> amsClazzConfigList = new ArrayList<>();
        for(AMSClazzConfigAware amsClazzConfigAware:amsClazzConfigAwareList){
            AMSClazzConfig amsClazzConfig = amsClazzConfigAware.getAMSClazzConfig();
            Validate.notNull(amsClazzConfig, "表配置不能为空!涉及类名:"+amsClazzConfigAware.getClass().getName());

            Validate.notEmpty(amsClazzConfig.projectName, "项目名不能为空!涉及类名:"+amsClazzConfigAware.getClass().getName());
            if(null!=amsClazzConfig.entityClass){
                amsClazzConfig.clazzName = amsClazzConfig.entityClass.getSimpleName();
                amsClazzConfig.requestClass = amsClazzConfig.entityClass;
                amsClazzConfig.responseClass = amsClazzConfig.entityClass;
            }else{
                Validate.notNull(amsClazzConfig.requestClass, "请求类不能为空!涉及类名:"+amsClazzConfigAware.getClass().getName());
                Validate.notNull(amsClazzConfig.responseClass, "响应类不能为空!涉及类名:"+amsClazzConfigAware.getClass().getName());
                Validate.notEmpty(amsClazzConfig.clazzName, "自定义类名不能为空!涉及类名:"+amsClazzConfigAware.getClass().getName());
            }
            Validate.notEmpty(amsClazzConfig.label, "表显示名称不能为空!涉及类名:"+amsClazzConfigAware.getClass().getName());
            amsClazzConfigList.add(amsClazzConfig);
        }
        flowContext.putContextData("amsClazzConfigList", amsClazzConfigList);
    }

    @Override
    public String name() {
        return "设置自定义类配置列表信息";
    }
}
