package cn.schoolwow.ams.module.config.controller;

import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.module.initial.service.SetAMSInfoCompositeBusiness;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import com.alibaba.fastjson.JSONArray;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

@Configuration
@ComponentScan(basePackages = "cn.schoolwow.ams")
public class AMSConfig {
    @Bean
    public QuickFlow amsFlow(ApplicationContext applicationContext){
        QuickFlow amsFlow = QuickFlowBuilder.newInstance()
                .putContextData("blocks", new JSONArray())
                .putContextData("scriptPathList", new ArrayList<>())
                .putContextData("remoteSelectContextList", new ArrayList<>())
                .putContextData("amsListenerList", applicationContext.getBeansOfType(AMSListener.class).values());
        //初始化
        amsFlow.executeFlow(applicationContext.getBean(SetAMSInfoCompositeBusiness.class));
        return amsFlow;
    }
}
