package cn.schoolwow.ams.domain;

import cn.schoolwow.quickdao.domain.DAO;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

public interface AMSListener {
    /**
     * 应用名称
     * */
    String projectName();

    /**
     * 前端显示名称
     * */
    String applicationName();

    /**
     * 返回类名是否是否属于controller层
     * */
    boolean isController(String className);

    /**
     * 返回待加载的脚本列表
     * */
    List<String> getScriptPathList();

    /**
     * 获取DAO对象
     * */
    DAO getDAO(String daoName);

    /**
     * 在打印异常前
     * */
    void beforePrintError(Exception e);

    /**
     * 返回额外数据
     * */
    JSONObject extraData();
}
