/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.module.initial.flow.get;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class GetBlockArrayFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setFromTableConfigList(flowContext);
        this.setFromClazzConfigList(flowContext);
        this.setCommonFields(flowContext);
    }

    public String name() {
        return "\u8bbe\u7f6eblock\u5217\u8868";
    }

    private void setFromTableConfigList(FlowContext flowContext) {
        List amsTableConfigList = (List)flowContext.getData("amsTableConfigList");
        if (null == amsTableConfigList || amsTableConfigList.isEmpty()) {
            return;
        }
        JSONArray blocks = (JSONArray)flowContext.getData("blocks");
        for (AMSTableConfig amsTableConfig : amsTableConfigList) {
            JSONObject block = new JSONObject();
            block.put("projectName", (Object)amsTableConfig.projectName);
            block.put("daoName", (Object)amsTableConfig.daoName);
            if (null != amsTableConfig.entity.clazz) {
                block.put("tableName", (Object)amsTableConfig.entity.clazz.getSimpleName());
            } else {
                block.put("tableName", (Object)amsTableConfig.tableName);
            }
            blocks.add((Object)block);
        }
    }

    private void setFromClazzConfigList(FlowContext flowContext) {
        List amsClazzConfigList = (List)flowContext.getData("amsClazzConfigList");
        if (null == amsClazzConfigList || amsClazzConfigList.isEmpty()) {
            return;
        }
        JSONArray blocks = (JSONArray)flowContext.getData("blocks");
        for (AMSClazzConfig amsClazzConfig : amsClazzConfigList) {
            JSONObject block = new JSONObject();
            block.put("projectName", (Object)amsClazzConfig.projectName);
            block.put("daoName", (Object)"clazz");
            block.put("tableName", (Object)amsClazzConfig.clazzName);
            blocks.add((Object)block);
        }
    }

    private void setCommonFields(FlowContext flowContext) {
        JSONArray blocks = (JSONArray)flowContext.getData("blocks");
        for (int i = 0; i < blocks.size(); ++i) {
            JSONObject block = blocks.getJSONObject(i);
            Validate.notEmpty((CharSequence)block.getString("projectName"), (String)"\u9879\u76ee\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)block.getString("daoName"), (String)"\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)block.getString("tableName"), (String)"\u5b9e\u4f53\u7c7b/\u81ea\u5b9a\u4e49\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String uniqueKey = block.getString("projectName") + "|" + block.getString("daoName") + "|" + block.getString("tableName");
            block.put("uniqueKey", (Object)uniqueKey);
            block.put("resourceName", (Object)(uniqueKey + "|resource"));
            block.put("listBlockName", (Object)(uniqueKey + "|listBlock"));
        }
    }
}

