/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.module.config.controller;

import cn.schoolwow.ams.domain.AMSGlobalConfig;
import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.domain.listener.operation.AMSDispatcherService;
import cn.schoolwow.ams.module.initial.flow.GetConfigFlow;
import cn.schoolwow.ams.module.initial.flow.RefreshExtraDataFlow;
import cn.schoolwow.ams.module.listener.operation.kit.DefaultAMSDispatcherService;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ams"})
public class AMSController
implements InitializingBean {
    @Autowired
    private QuickFlow amsFlow;
    @Autowired(required=false)
    private AMSGlobalConfig amsGlobalConfig;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private AMSDispatcherService amsDispatcherService;

    public void afterPropertiesSet() {
        if (null == this.amsDispatcherService) {
            this.amsDispatcherService = new DefaultAMSDispatcherService(this.amsFlow);
        }
    }

    @RequestMapping(value={"/config"})
    public JSONObject config(@RequestParam(value="projectName", required=false) String projectName) {
        if (null == projectName || projectName.isEmpty()) {
            projectName = this.getDefaultProjectName();
        }
        FlowContext flowContext = this.amsFlow.startFlow((BusinessFlow)this.applicationContext.getBean(GetConfigFlow.class)).putCurrentCompositeFlowData("projectName", (Object)projectName).execute();
        JSONObject config = (JSONObject)flowContext.checkData("config");
        return config;
    }

    @RequestMapping(value={"/refreshExtraData"})
    public JSONObject refreshExtraData(@RequestParam(value="projectName", required=false) String projectName) {
        if (null == projectName || projectName.isEmpty()) {
            projectName = this.getDefaultProjectName();
        }
        FlowContext flowContext = this.amsFlow.startFlow((BusinessFlow)this.applicationContext.getBean(RefreshExtraDataFlow.class)).putCurrentCompositeFlowData("projectName", (Object)projectName).execute();
        JSONObject extraData = (JSONObject)flowContext.getData("extraData");
        return extraData;
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/list"})
    public JSONObject list(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        return this.amsDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/create"})
    public void create(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject createEntity) throws Exception {
        this.amsDispatcherService.create(projectName, daoName, tableName, createEntity);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/edit"})
    public void edit(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject updateEntity) throws Exception {
        this.amsDispatcherService.edit(projectName, daoName, tableName, updateEntity);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/delete"})
    public void delete(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        this.amsDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/{methodName}"})
    public JSONObject operationDispatcher(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @PathVariable(value="methodName") String methodName, @RequestBody(required=false) JSONObject requestBody) throws Exception {
        return this.amsDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
    }

    @RequestMapping(value={"/api/{projectName}/remoteSelect/{type}"})
    public JSONArray remoteSelect(@PathVariable(value="projectName") String projectName, @PathVariable(value="type") String type, @RequestParam(required=false) Map<String, String> amsRemoteSelectMap) throws Exception {
        return this.amsDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
    }

    private String getDefaultProjectName() {
        Collection amsListenerCollection = (Collection)this.amsFlow.getContextData("amsListenerList");
        if (null != this.amsGlobalConfig) {
            return this.amsGlobalConfig.defaultProjectName();
        }
        if (amsListenerCollection.size() == 1) {
            return ((AMSListener)amsListenerCollection.iterator().next()).projectName();
        }
        throw new IllegalArgumentException("\u672a\u914d\u7f6eAMSGlobalConfig\u5bf9\u8c61\u6216\u8005ams\u9879\u76ee\u5927\u4e8e1\u4e2a!ams\u9879\u76ee\u4e2a\u6570:" + amsListenerCollection.size());
    }
}

