/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.flow.initial.get;

import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.list.AMSTableConfigAware;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetAMSTableConfigListFlow
implements BusinessFlow {
    @Autowired(required=false)
    private List<AMSTableConfigAware> amsTableListenerAwareList;

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if (null == this.amsTableListenerAwareList || this.amsTableListenerAwareList.isEmpty()) {
            return;
        }
        Collection amsListenerList = (Collection)flowContext.checkData("amsListenerList");
        ArrayList<AMSTableConfig> amsTableConfigList = new ArrayList<AMSTableConfig>();
        for (AMSTableConfigAware amsTableConfigAware : this.amsTableListenerAwareList) {
            AMSTableConfig amsTableConfig = amsTableConfigAware.getAMSTableConfig();
            Validate.notNull((Object)amsTableConfig, (String)("\u8868\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a!\u6d89\u53ca\u7c7b\u540d:" + amsTableConfigAware.getClass().getName()), (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)amsTableConfig.projectName, (String)("\u9879\u76ee\u540d\u4e0d\u80fd\u4e3a\u7a7a!\u5b57\u6bb5\u540d:projectName,\u6d89\u53ca\u7c7b\u540d:" + amsTableConfigAware.getClass().getName()), (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)amsTableConfig.daoName, (String)("DAO\u540d\u4e0d\u80fd\u4e3a\u7a7a!\u5b57\u6bb5\u540d:daoName,\u6d89\u53ca\u7c7b\u540d:" + amsTableConfigAware.getClass().getName()), (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)amsTableConfig.label, (String)("\u8868\u663e\u793a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!\u5b57\u6bb5\u540d:label,\u6d89\u53ca\u7c7b\u540d:" + amsTableConfigAware.getClass().getName()), (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)amsTableConfig.tableName) && null == amsTableConfig.entity) {
                throw new IllegalArgumentException("\u8868\u540d\u548cEntity\u7c7b\u5fc5\u987b\u8bbe\u7f6e\u5176\u4e2d\u4e00\u4e2a!\u6d89\u53ca\u7c7b\u540d:" + amsTableConfigAware.getClass().getName());
            }
            DAO dao = null;
            for (AMSListener amsListener : amsListenerList) {
                if (!amsListener.projectName().equals(amsTableConfig.projectName)) continue;
                dao = amsListener.getDAO(amsTableConfig.daoName);
                break;
            }
            Validate.notNull((Object)dao, (String)("\u6570\u636e\u5e93\u4e0d\u5b58\u5728!dao\u540d\u79f0:" + amsTableConfig.daoName + ",\u6d89\u53ca\u7c7b:" + amsTableConfigAware.getClass().getName()), (Object[])new Object[0]);
            if (null != amsTableConfig.tableName) {
                amsTableConfig.entity = dao.getDatabaseEntity(amsTableConfig.tableName);
            } else if (null != amsTableConfig.entity) {
                amsTableConfig.tableName = amsTableConfig.entity.tableName;
            }
            amsTableConfigList.add(amsTableConfig);
        }
        flowContext.putContextData("amsTableConfigList", amsTableConfigList);
    }

    public String name() {
        return "\u8bbe\u7f6e\u6570\u636e\u5e93\u8868\u914d\u7f6e\u5217\u8868\u4fe1\u606f";
    }
}

