/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.advice;

import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.ams.listener.AMSListener;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class AMSResponseBodyAdvice
implements ResponseBodyAdvice {
    @Autowired
    private List<AMSListener> amsListenerList;

    public boolean supports(MethodParameter returnType, Class converterType) {
        String className = returnType.getDeclaringClass().getName();
        if (className.startsWith("cn.schoolwow.ams")) {
            return true;
        }
        for (AMSListener amsListener : this.amsListenerList) {
            if (!amsListener.isController(className)) continue;
            return true;
        }
        return false;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof AMSResult) {
            return body;
        }
        return new AMSResult(body);
    }
}

