function getMatchBlock(block){
    //匹配公共部分
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];

        if(projectName===block["projectName"]&&daoName==="common"&&tableName===block["tableName"]){
            return userBlockMap[prop];
        }
    }
    //完全匹配
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];

        if(projectName===block["projectName"]&&daoName===block["daoName"]&&tableName===block["tableName"]){
            return userBlockMap[prop];
        }
    }
}

function loadBlock(block){
    let matchBlock = getMatchBlock(block);
    loadResource(block, matchBlock);
    loadListBlock(block, matchBlock);
}

function loadResource(block, matchBlock) {
    let resourceBlock = {
        "key": block["id"],
        "api": {
            "prefix": "/ams/api/"+block["projectName"]+"/"+block["daoName"]+"/"+block["tableName"],
            "list": "/list",
            "create": "/create",
            "update": "/update",
            "delete": "/delete"
        },
        "fields": block["resourceFields"]
    };
    if(null!=matchBlock&&matchBlock.hasOwnProperty("resource")){
        mergeBlock(matchBlock["resource"], resourceBlock);
        delete matchBlock["resource"];
    }
    ams.blockConfig["resourceBlockMap"][block["uniqueKey"]] = resourceBlock;
    ams.resource(block["resourceName"], resourceBlock);
}

function loadListBlock(block, matchBlock){
    let listBlock = {
        "resource": block["resourceName"],
        "type": "list",
        "ctx": "view",
        "props": {
            "empty-text": "暂无记录",
        },
        "sorts": {},
        "expand": {},
        "options": {
            "multipleSelect": true,
        },
        "operations":{

        },
        "actions": {
            fieldChange({field,name,value,path}){
                if(field["type"]==="select"){
                    this.callAction("list:1");
                }
            },
            initialCondition(){
                let searchFields = Object.keys(this["fields"]);
                for(let i=0;i<searchFields.length;i++){
                    let value = ams.utils.getQueryString(searchFields[i]);
                    if(null!=value&&value!==""){
                        value = decodeURIComponent(value);
                        this["data"]["searchs"][searchFields[i]] = value;
                    }
                }
                if(block["initList"]){
                    this.callAction("list:1");
                }
            },
            copyRow(params) {
                let row = params.$prevReturn;
                setClipBoard(JSON.stringify(row));
                this.$message.success("行数据已复制到剪贴板");
            },
            copyField(params){
                let row = params.$prevReturn;
                let arg = params["$arg"];
                if(arg.indexOf(",")>0){
                    let content = "";
                    let fieldNames = arg.split(",", -1);
                    for(let i=0;i<fieldNames.length;i++){
                        let val = row[fieldNames[i]];
                        if (typeof (val) == "object" || typeof (val) == "array") {
                            val = JSON.stringify(val);
                        }
                        content += val+"\r\n\r\n";
                    }
                    setClipBoard(content);
                }else{
                    let val = row[arg];
                    if (typeof (val) == "object" || typeof (val) == "array") {
                        val = JSON.stringify(val);
                    }
                    setClipBoard(val);
                }
                this.$message.success("信息已复制到剪贴板");
            },
            sendRequest(params){
                let operation = params["operation"];
                let row = params.$prevReturn;
                let arg = params["$arg"];
                let tokens = arg.split(",", -1);

                let fieldNameList = [];
                if(tokens.length>1){
                    for(let i=1;i<tokens.length;i++){
                        fieldNameList.push(tokens[i]);
                    }
                }

                let data = {};
                if(operation["slot"]==="rightTop"){
                    //不传递任何参数
                }else if(tokens[0].indexOf("multiple")===0){
                    if(fieldNameList.length===0){
                        data["list"] = row;
                    }else if(fieldNameList.length===1){
                        data[fieldNameList[0]+"List"] = ams.utils.getIdList(params, fieldNameList[0]);
                    }else{
                        let list = [];
                        if (Array.isArray(row)) {
                            for(let i=0;i<row.length;i++){
                                let o = {};
                                for(let j=0;j<fieldNameList.length;j++){
                                    o[fieldNameList[j]] = row[i][fieldNameList[j]];
                                }
                                list.push(o);
                            }
                        } else {
                            let o = {};
                            for(let j=0;j<fieldNameList.length;j++){
                                o[fieldNameList[j]] = row[fieldNameList[j]];
                            }
                            list.push(o);
                        }

                        data["list"] = list;
                    }
                }else{
                    if(fieldNameList.length===0){
                        data = row;
                    }else{
                        for(let j=0;j<fieldNameList.length;j++){
                            data[fieldNameList[j]] = row[fieldNameList[j]];
                        }
                    }
                }
                return ams.utils.sendRequest(this,{
                    "method": "POST",
                    "url": "/"+tokens[0],
                    "data": data
                }, operation["label"]+"执行完毕");
            },
            addBlockItemDialog(params) {
                let addBlockItemDialogOption = this["block"]["itemDialog"]["addBlockItemDialogOption"];
                let addFieldNameList = addBlockItemDialogOption["addFieldNameList"];
                let fields = ams.utils.getResourceFields(this, addFieldNameList);
                return ams.utils.addItemDialog(this,addBlockItemDialogOption["createApi"],fields);
            },
            editBlockItemDialog(params) {
                let editBlockItemDialogOption = this["block"]["itemDialog"]["editBlockItemDialogOption"];
                let fields = null;
                if(editBlockItemDialogOption.hasOwnProperty("showFieldNameList")&&null!=editBlockItemDialogOption["showFieldNameList"]){
                    if(editBlockItemDialogOption["showFieldNameList"].length>0){
                        fields = ams.utils.getResourceFields(this, editBlockItemDialogOption["showFieldNameList"]);
                    }
                }else{
                    fields = ams.utils.getResourceFields(this);
                }
                if(editBlockItemDialogOption.hasOwnProperty("disableFieldNameList")&&null!=editBlockItemDialogOption["disableFieldNameList"]){
                    if(editBlockItemDialogOption["disableFieldNameList"].length>0){
                        ams.utils.disabledResourceFields(fields, editBlockItemDialogOption["disableFieldNameList"]);
                    }
                }
                return ams.utils.editItemDialog(this,editBlockItemDialogOption["updateApi"],fields);
            },
            deleteRecord(params){
                let arg = params["$arg"];

                let idValueList = ams.utils.getIdsString(params, arg);
                let data = {};
                data[arg] = "in:"+idValueList;

                return ams.utils.sendRequest(this, {
                    "method": "POST",
                    "url": "/delete",
                    "data": data,
                    "contentType": "form"
                }, "删除记录完成!");
            }
        }
    };
    listBlock["events"] = {
        "init": "initialCondition"
    };
    listBlock["operations"] = block["operationFields"];
    //设置远程下拉框
    for(let prop in listBlock["operations"]){
        let operation = listBlock["operations"][prop];
        if(!operation.hasOwnProperty("field")){
            continue;
        }
        if(!operation["field"].hasOwnProperty("BASE")){
            continue;
        }
        if(operation["field"]["BASE"]==="SELECT_REMOTE"){
            operation["field"]["remoteConfig"]["transform"] = function($field, data) {
                //option格式需为{label:xx,value:xx}
                return data;
            }
        }
    }
    //设置复制按钮
    for(let prop in listBlock["operations"]){
        if(prop.indexOf("copy|")<0){
            continue;
        }
        let operation = listBlock["operations"][prop];
        operation["show"] = function(row){
            let fieldName = operation["event"].substring(operation["event"].indexOf(":")+1);
            let fieldNameList = fieldName.split(",", -1);
            let showFlag = false;
            for(let i=0;i<fieldNameList.length;i++){
                if(row.hasOwnProperty(fieldNameList[i])){
                    showFlag = true;
                    break;
                }
            }
            return showFlag;
        };
    }

    for(let prop in block["resourceFields"]){
        listBlock["sorts"][prop] = true;
        listBlock["expand"][prop] = true;
        if(prop==="id"){
            listBlock["data"] = {
                "searchs": {
                    "sortField": "id",
                    "sortOrder": "desc"
                }
            };
        }
    }

    listBlock["operations"] = Object.assign(listBlock["operations"], {
        "tableHeader": {
            "slot": "rightTop",
            "type": "filter",
            "label": "表头管理",
            "props": {
                "type": "primary",
            },
        },
        "copyRow": {
            "type": "button",
            "label": "复制行",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "event": "copyRow"
        },
    });

    listBlock["itemDialog"] = block["itemDialog"];

    mergeBlock(matchBlock, listBlock);
    if(!listBlock["operations"].hasOwnProperty("search")){
        listBlock["operations"]["search"] = {
            "slot": "searchs",
            "type": "button",
            "label": "搜索",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "list:1"
        };
    }

    ams.block(block["listBlockName"], listBlock);

    if(listBlock.hasOwnProperty("headerNames")){
        //设置默认表头展示列
        let itemName = "AMS_BLOCK_"+block["listBlockName"];
        if(null==localStorage.getItem(itemName)){
            localStorage.setItem(itemName,"\""+listBlock["headerNames"]+"\"");
        }
    }
}

function mergeBlock(sourceBlock,targetBlock){
    for(let prop in sourceBlock){
        if(!sourceBlock.hasOwnProperty(prop)){
            continue;
        }
        if(!targetBlock.hasOwnProperty(prop)){
            targetBlock[prop] = sourceBlock[prop];
            continue;
        }
        if(typeof(sourceBlock[prop])=="object"){
            mergeBlock(sourceBlock[prop], targetBlock[prop]);
        }else{
            targetBlock[prop] = sourceBlock[prop];
        }
    }
}