function getMatchBlock(block){
    //匹配公共部分
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];

        if(projectName===block["projectName"]&&daoName==="common"&&tableName===block["tableName"]){
            return userBlockMap[prop];
        }
    }
    //完全匹配
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];

        if(projectName===block["projectName"]&&daoName===block["daoName"]&&tableName===block["tableName"]){
            return userBlockMap[prop];
        }
    }
}

function loadBlock(block){
    let matchBlock = getMatchBlock(block);
    loadResource(block, matchBlock);
    loadListBlock(block, matchBlock);
}

function loadResource(block, matchBlock) {
    let resourceBlock = {
        "key": block["id"],
        "api": {
            "prefix": "/ams/api/"+block["projectName"]+"/"+block["daoName"]+"/"+block["tableName"],
            "list": "/list",
            "create": "/create",
            "update": "/update",
            "delete": "/delete"
        },
        "fields": block["resourceFields"]
    };
    if(null!=matchBlock&&matchBlock.hasOwnProperty("resource")){
        mergeBlock(matchBlock["resource"], resourceBlock);
        delete matchBlock["resource"];
    }
    ams.blockConfig["resourceBlockMap"][block["uniqueKey"]] = resourceBlock;
    ams.resource(block["resourceName"], resourceBlock);
}

function loadListBlock(block, matchBlock){
    let listBlock = {
        "resource": block["resourceName"],
        "type": "list",
        "ctx": "view",
        "props": {
            "empty-text": "暂无记录",
        },
        "sorts": {},
        "expand": {},
        "options": {
            "multipleSelect": true,
        },
        "operations":{

        },
        "actions": {
            fieldChange({field,name,value,path}){
                if(field["type"]==="select"){
                    this.callAction("list:1");
                }
            },
            initialCondition(){
                let searchFields = Object.keys(this["fields"]);
                for(let i=0;i<searchFields.length;i++){
                    let value = ams.utils.getQueryString(searchFields[i]);
                    if(null!=value&&value!==""){
                        value = decodeURIComponent(value);
                        this["data"]["searchs"][searchFields[i]] = value;
                    }
                }
                if(block["initList"]){
                    this.callAction("list:1");
                }
            },
            copyRow(params) {
                let row = params.$prevReturn;
                setClipBoard(JSON.stringify(row));
                this.$message.success("行数据已复制到剪贴板");
            },
            multipleDelete(params){
                let idFieldName = block["id"];
                let ids = ams.utils.getIdsString(params, idFieldName);
                let data = {};
                data[idFieldName] = "in:"+ids;

                return ams.utils.sendRequest(this, {
                    "method": "POST",
                    "url": "/delete",
                    "data": data,
                    "contentType": "form"
                }, "删除记录完成!");
            }
        }
    };
    listBlock["events"] = {
        "init": "initialCondition"
    };
    listBlock["operations"] = block["operationFields"];
    for(let prop in listBlock["operations"]){
        let operation = listBlock["operations"][prop];
        if(operation["field"].hasOwnProperty("BASE")&&operation["field"]["BASE"]==="SELECT_REMOTE"){
            operation["field"]["remoteConfig"]["transform"] = function($field, data) {
                //option格式需为{label:xx,value:xx}
                return data;
            }
        }
    }

    for(let prop in block["resourceFields"]){
        listBlock["sorts"][prop] = true;
        listBlock["expand"][prop] = true;
        if(prop==="id"){
            listBlock["data"] = {
                "searchs": {
                    "sortField": "id",
                    "sortOrder": "desc"
                }
            };
        }
    }

    listBlock["operations"] = Object.assign(listBlock["operations"], {
        "tableHeader": {
            "slot": "rightTop",
            "type": "filter",
            "label": "表头管理",
            "props": {
                "type": "primary",
            },
        },
        "copyRow": {
            "type": "button",
            "label": "复制行",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "event": "copyRow"
        },
    });

    if(block.hasOwnProperty("operations")){
        let operations = block["operations"];
        for(let i=0;i<operations.length;i++){
            let operation = operations[i];
            if(listBlock["operations"].hasOwnProperty(operation["key"])){
                continue;
            }
            let listBlockOperation = {
                "type": "button",
                "label": operation["label"],
                "props": operation["props"],
                "event": "confirm:确认"+operation["label"]+"吗? "+operation["key"]+" list:1"
            };
            listBlock["operations"][operation["key"]] = listBlockOperation;
            if(operation.hasOwnProperty("slot")){
                listBlockOperation["slot"] = operation["slot"];

                if(operation["slot"]==="multipleSelect"){
                    listBlockOperation["label"] = "批量"+listBlockOperation["label"];
                    listBlockOperation["event"] = "confirm:确认批量"+operation["label"]+"吗? "+operation["key"]+" list:1";

                    let rowOperationName = "row_"+operation["key"];
                    listBlock["operations"][rowOperationName] = {
                        "type": "button",
                        "label": operation["label"],
                        "props": operation["props"],
                        "event": "confirm:确认"+operation["label"]+"吗? "+operation["key"]
                    };
                }
            }
            listBlock["actions"][operation["key"]] = function(params){
                let data = {};
                let fieldNameList = operation["fieldNameList"];
                let row = params.$prevReturn;

                if(null==fieldNameList||(listBlockOperation.hasOwnProperty("slot")&&listBlockOperation["slot"]==="rightTop")){
                    //不传递任何参数
                }else if(operation["slot"]==="multipleSelect"){
                    if(fieldNameList.length===0){
                        data["list"] = row;
                    }else if(fieldNameList.length===1){
                        data[fieldNameList[0]+"List"] = ams.utils.getIdList(params, fieldNameList[0]);
                    }else{
                        let list = [];
                        if (Array.isArray(row)) {
                            for(let i=0;i<row.length;i++){
                                let o = {};
                                for(let j=0;j<fieldNameList.length;j++){
                                    o[fieldNameList[j]] = row[i][fieldNameList[j]];
                                }
                                list.push(o);
                            }
                        } else {
                            let o = {};
                            for(let j=0;j<fieldNameList.length;j++){
                                o[fieldNameList[j]] = row[fieldNameList[j]];
                            }
                            list.push(o);
                        }

                        data["list"] = list;
                    }
                }else{
                    if(fieldNameList.length===0){
                        data = row;
                    }else{
                        for(let j=0;j<fieldNameList.length;j++){
                            data[fieldNameList[j]] = row[fieldNameList[j]];
                        }
                    }
                }
                return ams.utils.sendRequest(this,{
                    "method": "POST",
                    "url": "/"+operation["key"],
                    "data": data
                }, operation["label"]+"执行完毕");
            }
        }
    }

    mergeBlock(matchBlock, listBlock);
    if(!listBlock["operations"].hasOwnProperty("search")){
        listBlock["operations"]["search"] = {
            "slot": "searchs",
            "type": "button",
            "label": "搜索",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "list:1"
        };
    }

    ams.block(block["listBlockName"], listBlock);

    if(listBlock.hasOwnProperty("headerNames")){
        //设置默认表头展示列
        let itemName = "AMS_BLOCK_"+block["listBlockName"];
        if(null==localStorage.getItem(itemName)){
            localStorage.setItem(itemName,"\""+listBlock["headerNames"]+"\"");
        }
    }
}

function mergeBlock(sourceBlock,targetBlock){
    for(let prop in sourceBlock){
        if(!sourceBlock.hasOwnProperty(prop)){
            continue;
        }
        if(!targetBlock.hasOwnProperty(prop)){
            targetBlock[prop] = sourceBlock[prop];
            continue;
        }
        if(typeof(sourceBlock[prop])=="object"){
            mergeBlock(sourceBlock[prop], targetBlock[prop]);
        }else{
            targetBlock[prop] = sourceBlock[prop];
        }
    }
}