package cn.schoolwow.ams.flow.controller;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.listener.AMSRemoteSelect;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Service
public class SetAmsInfoFlow implements BusinessFlow {
    @Autowired
    private AMSListener amsListener;

    @Autowired
    private AMSListListener amsListListener;

    @Autowired(required = false)
    private List<AMSOperation> amsOperationList;

    @Autowired(required = false)
    private List<AMSRemoteSelect> amsRemoteSelectList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        initialBlock(flowContext);
        setBlockUniqueKey(flowContext);
        setAMSOperation(flowContext);
        setScriptPath(flowContext);
        setAMSRemoteSelect(flowContext);
    }

    @Override
    public String name() {
        return "ams信息初始化";
    }

    private void initialBlock(FlowContext flowContext){
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        amsListListener.initialBlocks(blocks);
    }

    private void setBlockUniqueKey(FlowContext flowContext){
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(int i=0;i<blocks.size();i++){
            JSONObject block = blocks.getJSONObject(i);
            if(!block.containsKey("projectName")){
                block.put("projectName", amsListener.projectName());
            }
        }
        for(int i=0;i<blocks.size();i++){
            JSONObject block = blocks.getJSONObject(i);
            Validate.notEmpty(block.getString("projectName"), "block项目名不能为空");
            Validate.notEmpty(block.getString("daoName"), "block数据库名不能为空");
            Validate.notEmpty(block.getString("tableName"), "block表名不能为空");

            String uniqueKey = block.getString("projectName")+"|"+block.getString("daoName")+"|"+block.getString("tableName");
            block.put("uniqueKey", uniqueKey);
            block.put("resourceName", uniqueKey+"|resource");
            block.put("listBlockName", uniqueKey+"|listBlock");
        }
    }

    private void setAMSOperation(FlowContext flowContext){
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(AMSOperation amsOperation:amsOperationList){
            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                if(!amsListener.projectName().equals(block.getString("projectName"))){
                    continue;
                }
                if(!amsOperation.daoName().equals(block.getString("daoName"))){
                    continue;
                }
                if(!amsOperation.tableName().equals(block.getString("tableName"))){
                    continue;
                }
                String methodName = amsOperation.methodName();
                if(StringUtils.isBlank(methodName)){
                    continue;
                }
                if(methodName.endsWith("Ignore")){
                    continue;
                }

                if(!block.containsKey("operations")){
                    block.put("operations", new JSONArray());
                }
                JSONArray operations = block.getJSONArray("operations");
                JSONObject operation = new JSONObject();
                operation.put("key", amsOperation.methodName());
                operation.put("label", amsOperation.name());
                Validate.notEmpty(operation.getString("label"), "名称不能为空!类名:"+amsOperation.getClass().getName());
                operation.put("fieldNameList", amsOperation.fieldNameList());
                JSONObject props = new JSONObject();
                props.put("type", "primary");
                amsOperation.props(props);
                operation.put("props", props);
                if(amsOperation.methodName().startsWith("multiple")){
                    operation.put("slot", "multipleSelect");
                }
                if(amsOperation.methodName().endsWith("RightTop")){
                    operation.put("slot", "rightTop");
                }
                operations.add(operation);
            }
        }
    }

    private void setAMSRemoteSelect(FlowContext flowContext){
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(AMSRemoteSelect amsRemoteSelect:amsRemoteSelectList){
            String[] uniqueKeyFieldArray = amsRemoteSelect.uniqueKeyFieldArray();
            if(null==uniqueKeyFieldArray||uniqueKeyFieldArray.length==0){
                continue;
            }
            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                String uniqueKey = block.getString("uniqueKey");
                for(String uniqueKeyField:uniqueKeyFieldArray){
                    if(uniqueKeyField.startsWith(uniqueKey)){
                        String[] tokens = uniqueKeyField.split("\\|", -1);
                        String projectName = tokens[0];
                        String fieldName = tokens[3];
                        String comment = tokens[4];
                        String parameter = tokens.length>=6?tokens[5]:null;
                        if(!block.containsKey("operationFields")){
                            block.put("operationFields", new JSONObject());
                        }
                        JSONObject operationFields = block.getJSONObject("operationFields");
                        if(!operationFields.containsKey(fieldName)){
                            operationFields.put(fieldName, new JSONObject());
                        }
                        JSONObject operationField = operationFields.getJSONObject(fieldName);
                        setRemoteSelectOperation(projectName, comment, parameter, amsRemoteSelect.type(), operationField);

                        {
                            JSONObject resourceField = new JSONObject();
                            resourceField.put("label", comment);
                            resourceField.put("info", comment);
                            resourceField.put("type", "text");
                            block.getJSONObject("resourceFields").put(fieldName, resourceField);
                        }
                    }
                }
            }
        }
    }

    private void setScriptPath(FlowContext flowContext) throws IOException {
        List<String> scriptPathList = (List<String>) flowContext.getData("scriptPathList", new ArrayList<>());

        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/ams"));
        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/commonOperation"));
        amsListListener.initialScriptPath(scriptPathList);
    }

    private void setRemoteSelectOperation(String projectName, String comment, String parameter, String type, JSONObject operationField){
        operationField.put("slot", "searchs");
        operationField.put("type", "field");
        operationField.put("label", comment);

        {
            JSONObject field = new JSONObject();
            field.put("BASE", "SELECT_REMOTE");
            field.put("type", "select");
            field.put("info", comment);
            {
                JSONObject props = new JSONObject();
                props.put("placeholder", "请选择"+comment);
                props.put("clearable", true);
                props.put("multiple", false);
                field.put("props", props);
            }
            {
                JSONObject remoteConfig = new JSONObject();
                remoteConfig.put("dataPath", "data");
                remoteConfig.put("action", "/ams/api/"+projectName+"/remoteSelect/"+type+(StringUtils.isNotBlank(parameter)?"?"+parameter:""));
                remoteConfig.put("queryKey", "name");
                remoteConfig.put("isCache", false);
                field.put("remoteConfig", remoteConfig);
            }
            operationField.put("field", field);
        }
    }
}
