package cn.schoolwow.ams.flow.controller;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class GetConfigFlow implements BusinessFlow {
    @Value("${spring.profiles.active}")
    private String activeProfile;

    @Resource
    private ApplicationContext applicationContext;

    @Autowired
    private AMSListener amsListener;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());
        List<String> scriptPathList = (List<String>) flowContext.getData("scriptPathList", new ArrayList<>());

        if(!"docker".equals(activeProfile)){
            blocks.clear();
            scriptPathList.clear();

            flowContext.executeFlowList(applicationContext.getBean(SetAmsInfoFlow.class));
        }
        JSONObject config = new JSONObject();
        config.put("projectName", amsListener.projectName());
        config.put("applicationName", amsListener.applicationName());
        //修改blocks显示方式,方便前端排查
        JSONObject blockMap = new JSONObject();
        for(int i=0;i<blocks.size();i++){
            JSONObject block = blocks.getJSONObject(i);
            blockMap.put(block.getString("uniqueKey"), block);
        }
        config.put("blockMap", blockMap);
        config.put("scriptPathList", scriptPathList);
        config.put("extraData", amsListener.extraData());
        flowContext.putData("config", config);
    }

    @Override
    public String name() {
        return "获取ams页面配置信息";
    }
}
