package cn.schoolwow.ams.service;

import cn.schoolwow.ams.domain.listener.select.GetRemoteOption;
import cn.schoolwow.ams.flow.dispatcher.*;
import cn.schoolwow.ams.flow.dispatcher.common.DispatcherBeforeAfterFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

public class DefaultAMSDispatcherService implements AMSDispatcherService{
    private QuickFlow amsFlow;
    
    public DefaultAMSDispatcherService(QuickFlow amsFlow) {
        this.amsFlow = amsFlow;
    }

    @Override
    public JSONObject list(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        FlowContext flowContext = amsFlow.startFlow(new ListFlow())
                .beforeAfterFlowHandler(new DispatcherBeforeAfterFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("amsListConditionMap", amsListConditionMap)
                .execute();
        JSONObject amsPagingList = (JSONObject) flowContext.checkData("amsPagingList");
        return amsPagingList;
    }

    @Override
    public void create(String projectName, String daoName, String tableName, JSONObject createEntity) {
        amsFlow.startFlow(new CreateFlow())
                .beforeAfterFlowHandler(new DispatcherBeforeAfterFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("createEntity", createEntity)
                .execute();
    }

    @Override
    public void edit(String projectName, String daoName, String tableName, JSONObject updateEntity) {
        amsFlow.startFlow(new EditFlow())
                .beforeAfterFlowHandler(new DispatcherBeforeAfterFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("updateEntity", updateEntity)
                .execute();
    }

    @Override
    public void delete(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        amsFlow.startFlow(new DeleteFlow())
                .beforeAfterFlowHandler(new DispatcherBeforeAfterFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("amsListConditionMap", amsListConditionMap)
                .execute();
    }

    @Override
    public JSONObject operationDispatcher(String projectName, String daoName, String tableName, String methodName, JSONObject requestBody) {
        FlowContext flowContext = amsFlow.startFlow(new OperationDispatcherFlow())
                .beforeAfterFlowHandler(new DispatcherBeforeAfterFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("methodName", methodName)
                .putCurrentCompositeFlowData("requestBody", requestBody)
                .execute();
        JSONObject response = (JSONObject) flowContext.getData("response");
        return response;
    }

    @Override
    public JSONArray remoteSelect(String projectName, String type, Map<String, String> amsListConditionMap) {
        JSONArray amsRemoteSelectArray = (JSONArray) amsFlow.getContextData("amsRemoteSelectArray");
        for(int i=0;i<amsRemoteSelectArray.size();i++){
            JSONObject amsRemoteSelect = amsRemoteSelectArray.getJSONObject(i);
            if(type.equalsIgnoreCase(amsRemoteSelect.getString("type"))){
                GetRemoteOption getRemoteOption = (GetRemoteOption) amsRemoteSelect.get("getRemoteOption");
                return getRemoteOption.getRemoteOption(amsListConditionMap);
            }
        }
        throw new IllegalArgumentException("未匹配到下拉框选项!项目名:"+projectName+",类型:"+type);
    }

}
