package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Service
public class SetScriptPathFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<String> scriptPathList = (List<String>) flowContext.getData("scriptPathList", new ArrayList<>());

        Collection<AMSListener> amsListenerCollection = (Collection<AMSListener>) flowContext.getData("amsListenerList");
        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("/ams/commonOperation","static/ams/commonOperation"));
        for(AMSListener amsListener:amsListenerCollection){
            scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("/ams/"+amsListener.projectName(),"static/ams/"+amsListener.projectName()));
            List<String> currentScriptPathList = amsListener.getScriptPathList();
            if(null!=currentScriptPathList&&!currentScriptPathList.isEmpty()){
                scriptPathList.addAll(currentScriptPathList);
            }
        }
    }

    @Override
    public String name() {
        return "设置加载脚本路径";
    }

}
