package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.domain.listener.dialog.AMSDialog;
import cn.schoolwow.ams.domain.listener.list.AMSListBlock;
import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.routerpush.AMSRouterPush;
import cn.schoolwow.ams.domain.listener.select.AMSRemoteSelect;
import cn.schoolwow.ams.domain.listener.table.AMSTableListener;
import cn.schoolwow.ams.listener.*;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class InitialAwareListFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<AMSClazzListenerAware> amsClazzListenerAwareList;

    @Autowired(required = false)
    private List<AMSOperationAware> amsOperationAwareList;

    @Autowired(required = false)
    private List<AMSTableListenerAware> amsTableListenerAwareList;

    @Autowired(required = false)
    private List<AMSDialogAware> amsDialogAwareList;

    @Autowired(required = false)
    private List<AMSRemoteSelectAware> amsRemoteSelectAwareList;

    @Autowired(required = false)
    private List<AMSListBlockAware> amsListBlockAwareList;

    @Autowired(required = false)
    private List<AMSRouterPushAware>amsRouterPushAwareList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) {
        setAMSClazzListenerList(flowContext);
        setAMSOperationList(flowContext);
        setAMSTableListenerList(flowContext);
        setAMSDialogList(flowContext);
        setAMSRemoteSelectList(flowContext);
        setAMSListBlockList(flowContext);
        setAMSRouterPushList(flowContext);
    }

    @Override
    public String name() {
        return "初始化aware接口";
    }

    private void setAMSClazzListenerList(FlowContext flowContext){
        if(null==amsClazzListenerAwareList||amsClazzListenerAwareList.isEmpty()){
            return;
        }
        JSONArray amsClazzListenerArray = new JSONArray();
        for(AMSClazzListenerAware amsClazzListenerAware:amsClazzListenerAwareList){
            List<AMSClazzListener> amsClazzListenerList = amsClazzListenerAware.getAMSClazzListenerList();
            for(AMSClazzListener amsClazzListener:amsClazzListenerList){
                JSONObject listener = amsClazzListener.getListener();
                listener.put("awareClassName", amsClazzListenerAware.getClass().getName());
                Validate.notEmpty(listener.getString("projectName"), "项目名不能为空!涉及类名:"+amsClazzListenerAware.getClass().getName());
                Validate.notEmpty(listener.getString("className"), "实体类名不能为空!涉及类名:"+amsClazzListenerAware.getClass().getName());
                amsClazzListenerArray.add(listener);
            }
        }
        flowContext.putContextData("amsClazzListenerArray", amsClazzListenerArray);
    }

    private void setAMSOperationList(FlowContext flowContext){
        if(null==amsOperationAwareList||amsOperationAwareList.isEmpty()){
            return;
        }
        JSONArray amsOperationArray = new JSONArray();
        for(AMSOperationAware amsOperationAware:amsOperationAwareList){
            List<AMSOperation> amsOperationList = amsOperationAware.getAMSOperationList();
            for(AMSOperation amsOperation:amsOperationList){
                JSONObject listener = amsOperation.getListener();
                listener.put("awareClassName", amsOperationAware.getClass().getName());
                Validate.notEmpty(listener.getString("projectName"), "项目名不能为空!涉及类名:"+amsOperationAware.getClass().getName());
                Validate.notEmpty(listener.getString("daoName"), "数据库名不能为空!涉及类名:"+amsOperationAware.getClass().getName());
                Validate.notEmpty(listener.getString("tableName"), "表名不能为空!涉及类名:"+amsOperationAware.getClass().getName());
                Validate.notEmpty(listener.getString("position"), "按钮位置不能为空!涉及类名:"+amsOperationAware.getClass().getName());
                Validate.isTrue(listener.containsKey("handle"), "代码处理逻辑不能为空!涉及类名:"+amsOperationAware.getClass().getName());
                amsOperationArray.add(listener);
            }
        }
        flowContext.putContextData("amsOperationArray", amsOperationArray);
    }

    private void setAMSTableListenerList(FlowContext flowContext){
        if(null==amsTableListenerAwareList||amsTableListenerAwareList.isEmpty()){
            return;
        }
        JSONArray amsTableListenerArray = new JSONArray();
        for(AMSTableListenerAware amsTableListenerAware:amsTableListenerAwareList){
            List<AMSTableListener> amsTableListenerList = amsTableListenerAware.getAMSTableListenerList();
            for(AMSTableListener amsTableListener:amsTableListenerList){
                JSONObject listener = amsTableListener.getListener();
                listener.put("awareClassName", amsTableListenerAware.getClass().getName());
                Validate.notEmpty(listener.getString("projectName"), "项目名不能为空!涉及类名:"+amsTableListenerAware.getClass().getName());
                Validate.notEmpty(listener.getString("daoName"), "数据库名不能为空!涉及类名:"+amsTableListenerAware.getClass().getName());
                Validate.notEmpty(listener.getString("tableName"), "表名不能为空!涉及类名:"+amsTableListenerAware.getClass().getName());
                amsTableListenerArray.add(listener);
            }
        }
        flowContext.putContextData("amsTableListenerArray", amsTableListenerArray);
    }

    private void setAMSDialogList(FlowContext flowContext){
        if(null==amsDialogAwareList||amsDialogAwareList.isEmpty()){
            return;
        }
        JSONArray amsDialogArray = new JSONArray();
        for(AMSDialogAware amsDialogAware:amsDialogAwareList){
            List<AMSDialog> amsDialogList = amsDialogAware.getAMSDialogList();
            for(AMSDialog amsDialog:amsDialogList){
                JSONObject listener = amsDialog.getListener();
                listener.put("awareClassName", amsDialogAware.getClass().getName());
                Validate.notEmpty(listener.getString("projectName"), "项目名不能为空!涉及类名:"+amsDialogAware.getClass().getName());
                Validate.notEmpty(listener.getString("daoName"), "数据库名不能为空!涉及类名:"+amsDialogAware.getClass().getName());
                Validate.notEmpty(listener.getString("tableName"), "表名不能为空!涉及类名:"+amsDialogAware.getClass().getName());
                Validate.notEmpty(listener.getString("name"), "名称不能为空!涉及类名:"+amsDialogAware.getClass().getName());
                amsDialogArray.add(listener);
            }
        }
        flowContext.putContextData("amsDialogArray", amsDialogArray);
    }

    private void setAMSRemoteSelectList(FlowContext flowContext){
        if(null==amsRemoteSelectAwareList||amsRemoteSelectAwareList.isEmpty()){
            return;
        }
        JSONArray amsRemoteSelectArray = new JSONArray();
        for(AMSRemoteSelectAware amsRemoteSelectAware:amsRemoteSelectAwareList){
            List<AMSRemoteSelect> amsRemoteSelectList = amsRemoteSelectAware.getAMSRemoteSelectList();
            for(AMSRemoteSelect amsRemoteSelect:amsRemoteSelectList){
                JSONObject listener = amsRemoteSelect.getListener();
                listener.put("awareClassName", amsRemoteSelectAware.getClass().getName());
                Validate.notEmpty(listener.getString("type"), "下拉框类型名称不能为空!涉及类名:"+amsRemoteSelectAware.getClass().getName());
                Validate.notEmpty(listener.getString("getRemoteOption"), "获取远程下拉框选项函数不能为空!涉及类名:"+amsRemoteSelectAware.getClass().getName());
                amsRemoteSelectArray.add(listener);
            }
        }
        flowContext.putContextData("amsRemoteSelectArray", amsRemoteSelectArray);
    }

    private void setAMSListBlockList(FlowContext flowContext){
        if(null==amsListBlockAwareList||amsListBlockAwareList.isEmpty()){
            return;
        }
        JSONArray amsListBlockArray = new JSONArray();
        for(AMSListBlockAware amsListBlockAware:amsListBlockAwareList){
            List<AMSListBlock> amsListBlockList = amsListBlockAware.getListBlockList();
            for(AMSListBlock amsListBlock:amsListBlockList){
                JSONObject block = amsListBlock.getBlock();
                block.put("awareClassName", amsListBlockAware.getClass().getName());
                Validate.notEmpty(block.getString("projectName"), "项目名信息不能为空!涉及类名:"+amsListBlockAware.getClass().getName());
                Validate.notEmpty(block.getString("daoName"), "数据库名信息不能为空!涉及类名:"+amsListBlockAware.getClass().getName());
                Validate.notEmpty(block.getString("tableName"), "表名信息不能为空!涉及类名:"+amsListBlockAware.getClass().getName());
                amsListBlockArray.add(block);
            }
        }
        flowContext.putContextData("amsListBlockArray", amsListBlockArray);
    }

    private void setAMSRouterPushList(FlowContext flowContext){
        if(null==amsRouterPushAwareList||amsRouterPushAwareList.isEmpty()){
            return;
        }
        JSONArray amsRouterPushArray = new JSONArray();
        for(AMSRouterPushAware amsRouterPushAware:amsRouterPushAwareList){
            List<AMSRouterPush> amsRouterPushList = amsRouterPushAware.getAMSRouterPushList();
            for(AMSRouterPush amsRouterPush:amsRouterPushList){
                JSONObject listener = amsRouterPush.getListener();
                listener.put("awareClassName", amsRouterPushAware.getClass().getName());
                Validate.notEmpty(listener.getString("projectName"), "项目名信息不能为空!涉及类名:"+amsRouterPushAware.getClass().getName());
                Validate.notEmpty(listener.getString("daoName"), "数据库名信息不能为空!涉及类名:"+amsRouterPushAware.getClass().getName());
                Validate.notEmpty(listener.getString("tableName"), "表名信息不能为空!涉及类名:"+amsRouterPushAware.getClass().getName());
                Validate.notEmpty(listener.getString("name"), "按钮唯一标识信息不能为空!涉及类名:"+amsRouterPushAware.getClass().getName());
                Validate.notEmpty(listener.getString("label"), "按钮名称信息不能为空!涉及类名:"+amsRouterPushAware.getClass().getName());
                Validate.notEmpty(listener.getString("path"), "跳转路径信息不能为空!涉及类名:"+amsRouterPushAware.getClass().getName());
                Validate.isTrue(listener.containsKey("fieldNameMap"), "跳转参数列表信息不能为空!涉及类名:"+amsRouterPushAware.getClass().getName());
                amsRouterPushArray.add(listener);
            }
        }
        flowContext.putContextData("amsRouterPushArray", amsRouterPushArray);
    }
}
